/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.monitoring;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.timeout.ReadTimeoutException;
import java.time.Duration;
import java.util.Map;
import javax.net.ssl.SSLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.AbstractReactiveHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.cloud.gateway.route.Route;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.http.client.HttpClient;
import reactor.netty.http.client.HttpClientRequest;

public class GatewayRouteHealthIndicator
extends AbstractReactiveHealthIndicator {
    private static final Logger LOG = LoggerFactory.getLogger(GatewayRouteHealthIndicator.class);
    private final Route _route;
    private final SslBundle _sslBundle;

    public GatewayRouteHealthIndicator(Route route, SslBundle sslBundle) {
        this._route = route;
        this._sslBundle = sslBundle;
    }

    protected Mono<Health> doHealthCheck(Health.Builder builder) {
        try {
            return this.checkRoute(this._route);
        }
        catch (SSLException e) {
            LOG.error(e.getMessage());
            return Mono.just((Object)Health.down().build());
        }
    }

    private Mono<Health> checkRoute(Route route) throws SSLException {
        SslContext sslContext = SslContextBuilder.forClient().keyManager(this._sslBundle.getManagers().getKeyManagerFactory()).trustManager(this._sslBundle.getManagers().getTrustManagerFactory()).build();
        HttpClient httpClient = HttpClient.create().secure(ssl -> ssl.sslContext(sslContext));
        WebClient client = WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(httpClient)).baseUrl(route.getUri().toString()).build();
        String uri = route.getMetadata().getOrDefault("monitoring-uri", "/internal/monitoring/health").toString();
        return client.get().uri(uri, new Object[0]).httpRequest(request -> {
            HttpClientRequest nativeRequest = (HttpClientRequest)request.getNativeRequest();
            nativeRequest.responseTimeout(Duration.ofSeconds(2L));
        }).retrieve().onStatus(HttpStatusCode::is5xxServerError, clientResponse -> Mono.empty()).bodyToMono((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */).map(body -> {
            String stringStatus = body.getOrDefault("status", "DOWN").toString();
            if (!stringStatus.equals("UP")) {
                LOG.error("route {}, status: {}", (Object)route.getId(), (Object)stringStatus);
            } else {
                LOG.debug("route {}, status: {}", (Object)route.getId(), (Object)stringStatus);
            }
            return Health.status((String)stringStatus).withDetails(body).build();
        }).onErrorResume(e -> {
            if (e.getCause() != null && e.getCause() instanceof ReadTimeoutException) {
                LOG.error("route {} is down: timeout exception", (Object)route.getId());
                return Mono.just((Object)Health.down().withDetails(Map.of("error", "timeout when retrieving health")).build());
            }
            LOG.error("route {} is down: error {}", (Object)route.getId(), (Object)e.getMessage());
            return Mono.just((Object)Health.down().withException(e).build());
        });
    }

    public Route getRoute() {
        return this._route;
    }
}

