/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.gateway.controller;

import de.justsoftware.gateway.security.ErrorCode;
import de.justsoftware.gateway.security.oauth2.JustClientRegistrationService;
import java.util.Comparator;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import reactor.core.publisher.Mono;

@Controller
public class LoginLogoutController {
    public static final String OAUTH_2_LOGIN_PAGE = "/oauth2/login";
    private final JustClientRegistrationService _idpClientRepo;

    public LoginLogoutController(JustClientRegistrationService idpClientRepo) {
        this._idpClientRepo = idpClientRepo;
    }

    @GetMapping(value={"/oauth2/login"})
    public Mono<String> login(Model model, @RequestParam(value="errorCode", required=false) @Nullable ErrorCode errorCode, ServerHttpResponse response) {
        return this.getDesktopIdps().map(idps -> {
            if (errorCode != null) {
                response.setStatusCode((HttpStatusCode)errorCode.getHttpStatus());
                model.addAttribute("errorCode", (Object)errorCode);
            } else {
                model.addAttribute("idps", idps);
            }
            return "login";
        });
    }

    @GetMapping(value={"/just/loggedOut"})
    public String loggedOut() {
        return "loggedOut";
    }

    private Mono<List<ClientRegistration>> getDesktopIdps() {
        return this._idpClientRepo.getAllDesktopClients().map(idps -> idps.stream().sorted(Comparator.comparing(ClientRegistration::getClientName)).toList());
    }
}

