/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.util;

import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.lang3.StringUtils;

public class ZipUtil {
    public static String sanitizeFilename(String name) {
        return StringUtils.replaceEach((String)name.replaceAll("%", "%%"), (String[])new String[]{"/", "<", ">", "\\", ":", "?", "*", "\"", "|"}, (String[])new String[]{"%2F", "%3C", "%3E", "%5C", "%3A", "%3F", "%2A", "%22", "%7C"});
    }

    public static ZipArchiveOutputStream getZipArchiveOutputStream(HttpServletResponse response) throws IOException {
        ZipArchiveOutputStream zaos = new ZipArchiveOutputStream((OutputStream)response.getOutputStream());
        zaos.setEncoding("UTF-8");
        zaos.setFallbackToUTF8(true);
        zaos.setUseLanguageEncodingFlag(true);
        zaos.setCreateUnicodeExtraFields(ZipArchiveOutputStream.UnicodeExtraFieldPolicy.ALWAYS);
        return zaos;
    }
}

