/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.models;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.rest.models.DocumentListEntry;
import de.justsoftware.drive.rest.models.Person;
import io.swagger.v3.oas.annotations.media.Schema;
import java.time.Instant;
import org.jspecify.annotations.Nullable;

@Schema
public abstract class Document
implements DocumentListEntry {
    private final DocumentId _id;
    private final String _name;
    private final Person _owner;
    private final Instant _lastModified;
    private final DocumentVersionId _versionId;
    private final int _version;
    private final ImmutableSet<StaticAction> _allowedActions;
    private final @Nullable DocumentId _parentFolderId;
    private final boolean _publicLinksAvailable;

    Document(DocumentId id, DocumentVersionId versionId, String name, Person owner, Instant lastModified, int version, ImmutableSet<StaticAction> allowedActions, @Nullable DocumentId parentFolderId, boolean publicLinksAvailable) {
        this._id = id;
        this._versionId = versionId;
        this._name = name;
        this._owner = owner;
        this._lastModified = lastModified;
        this._version = version;
        this._allowedActions = allowedActions;
        this._parentFolderId = parentFolderId;
        this._publicLinksAvailable = publicLinksAvailable;
    }

    @Schema(required=true)
    public DocumentId getId() {
        return this._id;
    }

    @Schema(required=true)
    public DocumentVersionId getVersionId() {
        return this._versionId;
    }

    @Schema(required=true)
    public String getName() {
        return this._name;
    }

    @Schema(required=true)
    public Person getOwner() {
        return this._owner;
    }

    @Schema(description="The date of the last modification of this document", required=true)
    public Instant getLastModified() {
        return this._lastModified;
    }

    public int getVersion() {
        return this._version;
    }

    @Schema(description="the set of allowed actions", required=true)
    public ImmutableSet<StaticAction> getAllowedActions() {
        return this._allowedActions;
    }

    @Schema(description="the id of the parent folder of the document, null for root folders", required=false)
    public @Nullable DocumentId getParentFolderId() {
        return this._parentFolderId;
    }

    @Schema(description="whether there are public links for this document set.")
    public boolean isPublicLinksAvailable() {
        return this._publicLinksAvailable;
    }
}

