/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.exception.PermissionDeniedException;
import de.justsoftware.drive.business.file.VirusScannerService;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.model.AbstractId;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/virusscanner"}, produces={"application/json"})
@Schema(description="Virusscanner")
public class VirusScannerController {
    final VirusScannerService _virusScannerService;

    @Autowired
    public VirusScannerController(VirusScannerService virusScannerService) {
        this._virusScannerService = virusScannerService;
    }

    @Operation(description="Sends file in error state to be rescanned by our virusscanner")
    @RequestMapping(value={"/rescan/{fileVersionId}"}, method={RequestMethod.POST})
    public void rescan(AuthorizationContext authCtx, @PathVariable DocumentVersionId fileVersionId) {
        if (!authCtx.may((AbstractId)fileVersionId, StaticAction.DOCUMENT_READ)) {
            throw new PermissionDeniedException("not allowed");
        }
        this._virusScannerService.rescanFile(fileVersionId, authCtx.getNonnullTenantId());
    }
}

