/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.controllers;

import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.authorization.AuthorizationContext;
import de.justsoftware.drive.business.authorization.PersonAuthorizationContext;
import de.justsoftware.drive.business.common.FileUploadConfigProperties;
import de.justsoftware.drive.business.person.PersonConfigService;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.business.usergroup.UserGroupService;
import de.justsoftware.drive.common.document.model.DocumentListSortParams;
import de.justsoftware.drive.common.person.model.PersonConfigBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import de.justsoftware.drive.rest.models.DocumentListSortParamsUpdate;
import de.justsoftware.drive.rest.models.StartupConfig;
import de.justsoftware.permission.client.model.CoreApp;
import de.justsoftware.permission.client.model.Role;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.UUID;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api"}, produces={"application/json"})
@Schema(description="Configuration")
public class ConfigController {
    private final SettingsService _settingsService;
    private final String _fileSyncDownloadPageURL;
    private final ImmutableSet<String> _newFileTypes;
    private final UserGroupService _userGroupService;
    private final FileUploadConfigProperties _uploadConfigProperties;
    private final PersonConfigService _personConfigService;

    @Autowired
    public ConfigController(SettingsService settingsService, @Value(value="${just.drive.fileSync.downloadPageURL}") String fileSyncDownloadPageURL, @Value(value="#{'${just.drive.newfiles.extensions}'}") String[] newFileTypes, FileUploadConfigProperties uploadConfigProperties, UserGroupService userGroupService, PersonConfigService personConfigService) {
        this._settingsService = settingsService;
        this._fileSyncDownloadPageURL = fileSyncDownloadPageURL;
        this._uploadConfigProperties = uploadConfigProperties;
        this._newFileTypes = ImmutableSet.copyOf((Object[])newFileTypes);
        this._userGroupService = userGroupService;
        this._personConfigService = personConfigService;
    }

    @RequestMapping(value={"/config"}, method={RequestMethod.GET})
    @Operation(description="Retrieves the config needed at startup for the requesting user.")
    public StartupConfig startupConfig(PersonAuthorizationContext authCtx) {
        PersonId personId = authCtx.getPersonId();
        TenantId tenantId = authCtx.getNonnullTenantId();
        UserGroupId allUsersGroupId = this.getAllUsersGroupId((AuthorizationContext)authCtx, tenantId);
        DocumentListSortParams documentListSortParams = this._personConfigService.getPersonConfig(personId).getDocumentListSortParams();
        return new StartupConfig(this._settingsService.isPublicLinksEnabled(tenantId), personId, this._fileSyncDownloadPageURL, this._newFileTypes, this.mayCreateShares(authCtx), this._uploadConfigProperties.getUploadMaxFileSize().toBytes(), allUsersGroupId, documentListSortParams, this._settingsService.isAntivirusEnabled(tenantId));
    }

    private boolean mayCreateShares(PersonAuthorizationContext authCtx) {
        TenantId tenantId = authCtx.getTenantId();
        if (tenantId == null) {
            return false;
        }
        return authCtx.may(Role.writeApp((CoreApp)CoreApp.DRIVE, (UUID)((UUID)tenantId.getId())));
    }

    private @Nullable UserGroupId getAllUsersGroupId(AuthorizationContext authCtx, @Nullable TenantId tenantId) {
        if (tenantId == null) {
            return null;
        }
        UserGroupId allUsersGroupId = this._userGroupService.getAllUsersGroupId(tenantId);
        if (allUsersGroupId == null) {
            return null;
        }
        boolean maySeeAllUsersGroup = authCtx.may(Role.read((String)allUsersGroupId.asPermissionRole().asString()));
        if (!maySeeAllUsersGroup) {
            return null;
        }
        return allUsersGroupId;
    }

    @PostMapping(value={"/config/setDocumentListSortOrder"})
    public void setDocumentListSortOrder(PersonAuthorizationContext context, @RequestBody DocumentListSortParamsUpdate params) {
        PersonId personId = context.getPersonId();
        PersonConfigBO personConfig = this._personConfigService.getPersonConfig(personId);
        personConfig.setDocumentListSortParams(params.toDocumentListSortParams());
        this._personConfigService.savePersonConfig(personId, personConfig);
    }
}

