/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.config;

import de.justsoftware.drive.business.common.FileUploadConfigProperties;
import de.justsoftware.drive.rest.config.UpdatableMultipartConfigElement;
import jakarta.servlet.MultipartConfigElement;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={MultipartProperties.class})
public class MultipartConfiguration {
    private final MultipartProperties _multipartProperties;
    private final FileUploadConfigProperties _uploadConfigProperties;

    public MultipartConfiguration(MultipartProperties multipartProperties, FileUploadConfigProperties uploadConfigProperties) {
        this._multipartProperties = multipartProperties;
        this._uploadConfigProperties = uploadConfigProperties;
    }

    @Bean
    public MultipartConfigElement multipartConfigElement() {
        MultipartConfigElement multipartConfigElement = this._multipartProperties.createMultipartConfig();
        return new UpdatableMultipartConfigElement(multipartConfigElement.getLocation(), multipartConfigElement.getFileSizeThreshold(), this._uploadConfigProperties);
    }
}

