/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.rest.accessrequest.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.accessrequest.model.AccessRequestBO;
import de.justsoftware.drive.rest.accessrequest.AccessRequestFrontendService;
import de.justsoftware.drive.rest.models.Person;
import de.justsoftware.drive.rest.person.PersonFrontendService;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AccessRequestFrontendServiceImpl
implements AccessRequestFrontendService {
    private final PersonFrontendService _personFrontendService;

    @Autowired
    public AccessRequestFrontendServiceImpl(PersonFrontendService personFrontendService) {
        this._personFrontendService = personFrontendService;
    }

    public ImmutableList<Person> convertToRequestingUsers(ImmutableSet<AccessRequestBO> accessRequests) {
        ImmutableSet personIds = (ImmutableSet)accessRequests.stream().map(AccessRequestBO::getPersonId).collect(ImmutableSet.toImmutableSet());
        Stream<Person> personsById = this._personFrontendService.getFrontendPersons((Set)personIds).entrySet().stream().map(Map.Entry::getValue);
        return (ImmutableList)personsById.sorted(Comparator.comparing(Person::getFullname)).collect(ImmutableList.toImmutableList());
    }
}

