/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.sharepermission;

import de.justsoftware.drive.common.authorization.model.SharePrivilege;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.sharepermission.SharePermissionBO;
import de.justsoftware.permission.client.model.Role;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ibatis.annotations.Arg;
import org.apache.ibatis.annotations.ConstructorArgs;
import org.apache.ibatis.annotations.Delete;
import org.apache.ibatis.annotations.Insert;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;

@Mapper
public interface SharePermissionMapper {
    @Select(value={"<script>", "SELECT share_id, role_name, permission FROM share_permission", "WHERE share_id IN (<foreach collection='shares' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="share_id", property="row", javaType=ItemId.class), @Result(column="role_name", property="col", javaType=Role.class), @Result(column="permission", property="value", javaType=SharePrivilege.class)})
    @ResultType(value=Map.class)
    public void getPermissions(ResultHandler<Map<String, Object>> var1, @Param(value="shares") List<ItemId> var2);

    @Delete(value={"DELETE from share_permission WHERE share_id = #{shareId}"})
    public void deletePermissions(@Param(value="shareId") ItemId var1);

    @Delete(value={"DELETE from share_permission WHERE role_name = #{role}"})
    public void deletePermissionsForRole(@Param(value="role") Role var1);

    @Insert(value={"INSERT INTO share_permission(share_id, role_name, permission) VALUES (#{share_id}, #{role}, #{permission})"})
    public void setPermission(@Param(value="share_id") ItemId var1, @Param(value="role") Role var2, @Param(value="permission") SharePrivilege var3);

    @Select(value={"<script>", "SELECT share_id, role_name FROM share_permission", "WHERE role_name IN (<foreach collection='roles' item='r' separator=','>#{r}</foreach>)", "AND share_id LIKE 'SHARE,%'", "</script>"})
    @Results(value={@Result(column="role_name", property="key", javaType=Role.class), @Result(column="share_id", property="value", javaType=ItemId.class)})
    @ResultType(value=Map.class)
    public void getSharesAccessibleBy(ResultHandler<Map<String, Object>> var1, @Param(value="roles") List<Role> var2);

    @Select(value={"SELECT share_id, role_name, permission FROM share_permission"})
    @ResultType(value=SharePermissionBO.class)
    @ConstructorArgs(value={@Arg(column="share_id", javaType=ItemId.class), @Arg(column="role_name", javaType=Role.class), @Arg(column="permission", javaType=SharePrivilege.class)})
    public void forEach(ResultHandler<SharePermissionBO> var1);

    @Delete(value={"<script>", "DELETE FROM share_permission", "WHERE share_id IN (<foreach collection='shareIds' item='shareId' separator=','>#{shareId}</foreach>)", "</script>"})
    public void deleteShares(@Param(value="shareIds") List<ItemId> var1);

    @Select(value={"SELECT role_name FROM share_permission where role_name LIKE 'TENANT,%'"})
    @ResultType(value=Role.class)
    public Set<Role> getAllTenantRoles();

    @Update(value={"UPDATE share_permission sp SET role_name = #{allUsersGroupRole} where role_name = #{tenantRole} ", "AND NOT EXISTS (SELECT 1 FROM share_permission sp2 WHERE role_name = #{allUsersGroupRole} and sp.share_id = sp2.share_id )"})
    public void migrateTenantRole(@Param(value="tenantRole") Role var1, @Param(value="allUsersGroupRole") Role var2);

    @Delete(value={"DELETE FROM share_permission WHERE role_name = #{tenantRole}"})
    public void deleteAllTenantRoles(@Param(value="tenantRole") Role var1);
}

