/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.publiclinks;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.publiclinks.model.PublicLinkBO;
import de.justsoftware.drive.common.tenant.model.TenantId;
import java.time.Instant;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public interface PublicLinkDAO {
    public String createPublicLink(PersonId var1, DocumentId var2, TenantId var3, Instant var4, @Nullable String var5);

    default public String createPublicLink(PersonId personId, DocumentId fileId, TenantId tenantId, Instant expires) {
        return this.createPublicLink(personId, fileId, tenantId, expires, null);
    }

    public @Nullable PublicLinkBO getPublicLink(String var1);

    public ImmutableList<PublicLinkBO> getPublicLinks(DocumentId var1);

    public ImmutableSet<DocumentId> hasLinks(Set<DocumentId> var1);

    public void deleteLink(DocumentId var1, String var2);

    public void deleteAllForTenant(TenantId var1);

    public void deleteExpiredLinks();

    @VisibleForTesting
    public ImmutableList<String> getPublicLinksIncludingExpired(Set<DocumentId> var1);

    public void updateLink(DocumentId var1, String var2, @Nullable Instant var3, @Nullable String var4);
}

