/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.person;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.common.person.model.PersonBO;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.mybatis.DAOSupport;
import de.justsoftware.drive.persistence.person.PersonCreateModel;
import de.justsoftware.drive.persistence.person.PersonDAO;
import de.justsoftware.drive.persistence.person.PersonMapper;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PersonDAOImpl
implements PersonDAO {
    private final PersonMapper _personMapper;
    private final DAOSupport _daoSupport;

    @Autowired
    public PersonDAOImpl(PersonMapper personMapper, DAOSupport daoSupport) {
        this._personMapper = personMapper;
        this._daoSupport = daoSupport;
    }

    public ImmutableMap<PersonId, PersonBO> getPersons(Set<PersonId> personIds) {
        return (ImmutableMap)this._daoSupport.partition(personIds).index(PersonBO::getId).asMap().query((arg_0, arg_1) -> ((PersonMapper)this._personMapper).getPersons(arg_0, arg_1));
    }

    public void insertOrUpdate(PersonCreateModel personCreateModel) {
        this._personMapper.insertPerson(personCreateModel._id);
        this._personMapper.updatePerson(personCreateModel);
    }
}

