/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.mybatis.type.common;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeReference;

@MappedJdbcTypes(value={JdbcType.VARCHAR, JdbcType.CHAR, JdbcType.LONGVARCHAR, JdbcType.NVARCHAR, JdbcType.NCHAR}, includeNullJdbcType=true)
@MappedTypes(value={String.class})
public class StringNullToEmptyTypeHandler
extends TypeReference<String>
implements TypeHandler<String> {
    public void setParameter(PreparedStatement ps, int i, String parameter, JdbcType jdbcType) throws SQLException {
        if (parameter == null || parameter.isEmpty()) {
            ps.setNull(i, (jdbcType != null ? jdbcType : JdbcType.VARCHAR).TYPE_CODE);
        } else {
            ps.setString(i, parameter);
        }
    }

    public String getResult(ResultSet rs, String columnName) throws SQLException {
        String result = rs.getString(columnName);
        return rs.wasNull() || result == null ? "" : result;
    }

    public String getResult(ResultSet rs, int columnIndex) throws SQLException {
        String result = rs.getString(columnIndex);
        return rs.wasNull() || result == null ? "" : result;
    }

    public String getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String result = cs.getString(columnIndex);
        return cs.wasNull() || result == null ? "" : result;
    }
}

