/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.item;

import com.google.common.collect.ImmutableMap;
import de.justsoftware.drive.common.item.model.ItemBO;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.item.model.ItemType;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.persistence.item.ItemCreateModel;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;

public interface ItemDAO {
    public void setNames(Map<ItemId, String> var1);

    default public @Nullable ItemBO findItem(ItemId itemId) {
        return (ItemBO)this.getItems(Set.of(itemId)).getOrDefault((Object)itemId, null);
    }

    public ImmutableMap<ItemId, ItemBO> getItems(Set<ItemId> var1);

    public void markAsDeleted(Set<ItemId> var1);

    public void markAsActiveIfDeleted(Set<ItemId> var1);

    public void storeItems(Map<ItemId, ItemCreateModel> var1);

    public int forAllItemsWithDocuments(int var1, Consumer<List<ItemId>> var2);

    public void forEachItemOfTypeWithAtLeastNChanges(ItemType var1, int var2, Consumer<ItemId> var3);

    public int forAllShares(Consumer<ItemBO> var1);

    public Set<ItemId> getAllShareIds(TenantId var1);

    public Set<ItemBO> getAllSharesForTenant(TenantId var1);

    public Set<ItemId> getDeletedItemsForTypes(Duration var1, Set<ItemType> var2);

    public Set<ItemId> filterDeleted(Set<ItemId> var1);

    public void deleteItems(Set<ItemId> var1);

    public void setTenantIdIfNotExists(ItemId var1, TenantId var2);

    public void insertItem(ItemCreateModel var1);
}

