/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.document;

import com.google.common.base.Preconditions;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.person.model.PersonId;
import java.time.Instant;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public abstract class DocumentVersionCreateModel<D extends DocumentVersionCreateModel<D>> {
    final DocumentVersionId _id;
    DocumentVersionId _changeId;
    DocumentId _documentId;
    int _version = 1;
    String _name;
    @Nullable DocumentVersionId _firstPublishedChangeId;
    PersonId _owner;
    Instant _changeDate;

    protected DocumentVersionCreateModel(DocumentVersionId id) {
        this._id = id;
    }

    public DocumentVersionId getId() {
        return this._id;
    }

    public DocumentId getDocumentId() {
        return (DocumentId)Preconditions.checkNotNull((Object)this._documentId);
    }

    public String getName() {
        return (String)Preconditions.checkNotNull((Object)this._name);
    }

    public D setDocumentId(DocumentId documentId) {
        this._documentId = documentId;
        return (D)this.self();
    }

    public D setVersion(int version) {
        this._version = version;
        return (D)this.self();
    }

    public D setNextVersionOf(DocumentVersionBO bo) {
        return (D)this.setVersion(bo.getVersion() + 1);
    }

    public int getVersion() {
        return this._version;
    }

    public D setChangeId(DocumentVersionId changeId) {
        this._changeId = changeId;
        return (D)this.self();
    }

    public D setFirstPublishedChangeId(@Nullable DocumentVersionId firstPublishedChangeId) {
        this._firstPublishedChangeId = firstPublishedChangeId;
        return (D)this.self();
    }

    public D setName(String name) {
        this._name = name;
        return (D)this.self();
    }

    public D setChangeDate(Instant changeDate) {
        this._changeDate = changeDate;
        return (D)this.self();
    }

    public D setOwner(PersonId owner) {
        this._owner = owner;
        return (D)this.self();
    }

    protected final D newVersionOf(DocumentVersionBO businessObject) {
        return (D)this.setDocumentId(businessObject.getDocumentId()).setName(businessObject.getName()).setNextVersionOf(businessObject);
    }

    protected abstract D self();

    public boolean isRoot() {
        return Objects.equals(this._id, this._changeId);
    }
}

