/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.document;

import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Result;
import org.apache.ibatis.annotations.ResultType;
import org.apache.ibatis.annotations.Results;
import org.apache.ibatis.annotations.Select;
import org.apache.ibatis.annotations.Update;
import org.apache.ibatis.session.ResultHandler;

@Mapper
public interface DocumentVersionCountMapper {
    @Update(value={"<script>", "<if test=\"_databaseId == 'ORACLE'\">", "MERGE INTO document_version_count T", "USING (SELECT DOCS.ID,", "       COALESCE(counters.count, 1) AS count", "       FROM document_version docs", "       LEFT JOIN document_version_count counters ON (docs.ID = counters.ID)", "       WHERE docs.id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", ") S ON (s.id = t.id)", "WHEN MATCHED THEN", "  UPDATE SET T.count = S.count + 1", "WHEN NOT MATCHED THEN", "  INSERT (T.id, T.count) VALUES (S.id, S.count)", "</if>", "<if test=\"_databaseId == 'POSTGRES'\">", "INSERT INTO document_version_count (id, count)", "VALUES <foreach collection='ids' item='i' separator=','>(#{i}, 1)</foreach>", "ON CONFLICT ON CONSTRAINT document_version_count_pk DO", "UPDATE SET count = document_version_count.count + 1", "</if>", "</script>"})
    public void increment(@Param(value="ids") List<DocumentVersionId> var1);

    @Select(value={"<script>", "SELECT id, count", "FROM document_version_count", "WHERE id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "</script>"})
    @Results(value={@Result(column="id", property="key", javaType=DocumentVersionId.class), @Result(column="count", property="value", javaType=Integer.class)})
    @ResultType(value=Map.class)
    public void getCount(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentVersionId> var2);

    @Select(value={"<script>", "SELECT dv.document_id AS id, sum(dc.count) AS count", "FROM document_version_count dc", "JOIN document_version dv ON (dv.id = dc.id)", "WHERE dv.document_id IN (<foreach collection='ids' item='i' separator=','>#{i}</foreach>)", "GROUP BY dv.document_id", "</script>"})
    @Results(value={@Result(column="id", property="key", javaType=DocumentId.class), @Result(column="count", property="value", javaType=Integer.class)})
    @ResultType(value=Map.class)
    public void getCountByDocument(ResultHandler<Map<String, Object>> var1, @Param(value="ids") List<DocumentId> var2);
}

