/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.persistence.common.typehandler;

import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.drive.common.document.model.DocumentListSortParams;
import de.justsoftware.drive.common.document.model.DocumentSortField;
import de.justsoftware.drive.common.model.SortDirection;
import de.justsoftware.drive.mybatis.type.StringBasedTypeHandler;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={DocumentListSortParams.class})
public class DocumentListSortTypeHandler
extends StringBasedTypeHandler<DocumentListSortParams> {
    @SuppressFBWarnings(value={"MC_OVERRIDABLE_METHOD_CALL_IN_CONSTRUCTOR"}, justification="would need refactoring")
    public DocumentListSortTypeHandler() {
        super(DocumentListSortTypeHandler::fromString, DocumentListSortTypeHandler::convertToString);
    }

    @VisibleForTesting
    static DocumentListSortParams fromString(String raw) {
        String[] split = raw.split(",");
        if (split.length != 2) {
            return DocumentListSortParams.DEFAULT;
        }
        try {
            return new DocumentListSortParams(DocumentSortField.valueOf((String)split[0]), SortDirection.valueOf((String)split[1]));
        }
        catch (IllegalArgumentException e) {
            return DocumentListSortParams.DEFAULT;
        }
    }

    @VisibleForTesting
    static String convertToString(DocumentListSortParams documentListSortParams) {
        return String.join((CharSequence)",", documentListSortParams.getColumn().toString(), documentListSortParams.getDirection().toString());
    }
}

