/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.mybatis.type;

import de.justsoftware.drive.mybatis.type.AbstractDriverSpecificTypeHandler;
import de.justsoftware.drive.mybatis.type.TypeHandlers;
import java.nio.ByteBuffer;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.UUID;
import java.util.function.Function;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.jspecify.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
@MappedJdbcTypes(value={JdbcType.OTHER, JdbcType.BINARY, JdbcType.VARBINARY}, includeNullJdbcType=true)
public abstract class UUIDBasedTypeHandler<ID>
extends AbstractDriverSpecificTypeHandler<ID> {
    private static final int UUID_BYTES = 16;
    private final Function<UUID, ID> _fromUUID;
    private final Function<ID, UUID> _toUUID;

    public UUIDBasedTypeHandler(Class<ID> clz, Function<ID, UUID> toUUID) {
        this(TypeHandlers.construct(clz, UUID.class), toUUID);
    }

    public UUIDBasedTypeHandler(Function<UUID, ID> fromUUID, Function<ID, UUID> toUUID) {
        this._fromUUID = fromUUID;
        this._toUUID = toUUID;
    }

    private static byte[] toByteArray(UUID uuid) {
        return ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
    }

    private @Nullable ID createIdNullable(@Nullable UUID id) {
        return id != null ? (ID)this._fromUUID.apply(id) : null;
    }

    protected void setNonNullParameterPostgres(PreparedStatement ps, int i, ID parameter, @Nullable JdbcType jdbcType) throws SQLException {
        UUID uuid = (UUID)this._toUUID.apply(parameter);
        if (jdbcType != null) {
            ps.setObject(i, (Object)uuid, jdbcType.TYPE_CODE);
        } else {
            ps.setObject(i, uuid);
        }
    }

    protected @Nullable ID getNullableResultPostgres(ResultSet rs, String columnName) throws SQLException {
        return (ID)this.createIdNullable((UUID)rs.getObject(columnName));
    }

    protected @Nullable ID getNullableResultPostgres(ResultSet rs, int columnIndex) throws SQLException {
        return (ID)this.createIdNullable((UUID)rs.getObject(columnIndex));
    }

    protected @Nullable ID getNullableResultPostgres(CallableStatement cs, int columnIndex) throws SQLException {
        return (ID)this.createIdNullable((UUID)cs.getObject(columnIndex));
    }

    private @Nullable ID createIdNullable(@Nullable byte[] obj) {
        if (obj == null || obj.length == 0) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(obj);
        long mostSignificantBits = buffer.getLong();
        long leastSignificantBits = buffer.getLong();
        return (ID)this.createIdNullable(new UUID(mostSignificantBits, leastSignificantBits));
    }

    protected void setNonNullParameterOracle(PreparedStatement ps, int i, ID parameter, @Nullable JdbcType jdbcType) throws SQLException {
        ps.setBytes(i, UUIDBasedTypeHandler.toByteArray((UUID)((UUID)this._toUUID.apply(parameter))));
    }

    protected @Nullable ID getNullableResultOracle(ResultSet rs, String columnName) throws SQLException {
        return (ID)this.createIdNullable(rs.getBytes(columnName));
    }

    protected @Nullable ID getNullableResultOracle(ResultSet rs, int columnIndex) throws SQLException {
        return (ID)this.createIdNullable(rs.getBytes(columnIndex));
    }

    protected @Nullable ID getNullableResultOracle(CallableStatement cs, int columnIndex) throws SQLException {
        return (ID)this.createIdNullable(cs.getBytes(columnIndex));
    }
}

