/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.mybatis.result;

import java.util.function.Consumer;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;

public final class CountingResultHandler<T>
implements ResultHandler<T> {
    private final Consumer<T> _consumer;
    private int _count = 0;

    public CountingResultHandler(Consumer<T> consumer) {
        this._consumer = consumer;
    }

    public void handleResult(ResultContext<? extends T> resultContext) {
        ++this._count;
        this._consumer.accept(resultContext.getResultObject());
    }

    public int applyTo(Consumer<ResultHandler<T>> method) {
        method.accept((ResultHandler<CountingResultHandler>)this);
        return this._count;
    }
}

