/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.mybatis;

import java.sql.SQLException;
import java.util.List;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.cursor.Cursor;
import org.apache.ibatis.executor.BatchResult;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.transaction.Transaction;

public final class AutoFlushExecutor
implements Executor {
    private final Executor _delegate;
    private final int _limit;
    private int _counter;

    public AutoFlushExecutor(Executor delegate, int limit) {
        this._delegate = delegate;
        delegate.setExecutorWrapper((Executor)this);
        this._limit = limit;
    }

    public int update(MappedStatement ms, Object parameter) throws SQLException {
        ++this._counter;
        if (this._counter > this._limit) {
            this.flushStatements();
        }
        return this._delegate.update(ms, parameter);
    }

    public List<BatchResult> flushStatements() throws SQLException {
        this._counter = 0;
        return this._delegate.flushStatements();
    }

    public <E> List<E> query(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, CacheKey cacheKey, BoundSql boundSql) throws SQLException {
        return this._delegate.query(ms, parameter, rowBounds, resultHandler, cacheKey, boundSql);
    }

    public <E> List<E> query(MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler) throws SQLException {
        return this._delegate.query(ms, parameter, rowBounds, resultHandler);
    }

    public void commit(boolean required) throws SQLException {
        this._delegate.commit(required);
    }

    public void rollback(boolean required) throws SQLException {
        this._delegate.rollback(required);
    }

    public CacheKey createCacheKey(MappedStatement ms, Object parameterObject, RowBounds rowBounds, BoundSql boundSql) {
        return this._delegate.createCacheKey(ms, parameterObject, rowBounds, boundSql);
    }

    public boolean isCached(MappedStatement ms, CacheKey key) {
        return this._delegate.isCached(ms, key);
    }

    public void clearLocalCache() {
        this._delegate.clearLocalCache();
    }

    public void deferLoad(MappedStatement ms, MetaObject resultObject, String property, CacheKey key, Class<?> targetType) {
        this._delegate.deferLoad(ms, resultObject, property, key, targetType);
    }

    public Transaction getTransaction() {
        return this._delegate.getTransaction();
    }

    public void close(boolean forceRollback) {
        this._delegate.close(forceRollback);
    }

    public boolean isClosed() {
        return this._delegate.isClosed();
    }

    public void setExecutorWrapper(Executor executor) {
        this._delegate.setExecutorWrapper(executor);
    }

    public <E> Cursor<E> queryCursor(MappedStatement ms, Object parameter, RowBounds rowBounds) throws SQLException {
        return this._delegate.queryCursor(ms, parameter, rowBounds);
    }
}

