/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.usergroup.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import de.justsoftware.drive.business.kafka.AbstractKafkaConsumer;
import de.justsoftware.drive.business.kafka.KafkaConfigurationProvider;
import de.justsoftware.drive.business.usergroup.UserGroupModificationService;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.common.usergroup.model.UserGroupId;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class UserGroupConsumerImpl
extends AbstractKafkaConsumer<String, String> {
    private static final String ALL_USERS_GROUP_PLACEHOLDER = " ";
    private static final Logger LOG = LoggerFactory.getLogger(UserGroupConsumerImpl.class);
    private static final String TOPIC = "just.people.userGroup";
    private final UserGroupModificationService _userGroupModificationService;

    @Autowired
    public UserGroupConsumerImpl(KafkaConfigurationProvider kafkaConfigurationProvider, TransactionSupport transactionSupport, UserGroupModificationService userGroupModificationService) {
        this(kafkaConfigurationProvider.stringConsumer("just.drive.UserGroupConsumerV2"), transactionSupport, userGroupModificationService);
    }

    @VisibleForTesting
    UserGroupConsumerImpl(@Nullable Consumer<String, String> consumer, TransactionSupport transactionSupport, UserGroupModificationService userGroupModificationService) {
        super(consumer, transactionSupport, "just.people.userGroup");
        this._userGroupModificationService = userGroupModificationService;
    }

    protected void process(ConsumerRecords<String, String> records, java.util.function.Consumer<Runnable> afterCommitCallbackConsumer) {
        records.forEach(r -> this.processRecord((String)r.key(), (String)r.value()));
    }

    @VisibleForTesting
    void processRecord(@Nullable String key, @Nullable String value) {
        Optional.ofNullable(key).map(k -> StringUtils.removeStart((String)k, (String)"USER_GROUP,")).flatMap(UserGroupId::parse).ifPresent(id -> {
            if (value == null) {
                this._userGroupModificationService.deleteUserGroup(id);
            } else {
                boolean looksLikeAllUsersGroup;
                JsonNode json = this.parseJson(value);
                String name = ((String)UserGroupConsumerImpl.parseString((JsonNode)json, (String)"name").or((Object)"")).trim();
                boolean isAllUsersGroup = UserGroupConsumerImpl.parseBoolean((JsonNode)json, (String)"isAllTenantUsersGroup", (boolean)false);
                Optional tenantId = UserGroupConsumerImpl.parseTenantId((JsonNode)json);
                boolean bl = looksLikeAllUsersGroup = name.isBlank() && isAllUsersGroup;
                if (looksLikeAllUsersGroup) {
                    name = " ";
                }
                if (tenantId.isEmpty() || name.isBlank() && !looksLikeAllUsersGroup) {
                    LOG.warn("Could not parse user group from Kafka topic. Name is blank and it's not a 'all users' group; or tenant id is missing.");
                    return;
                }
                this._userGroupModificationService.saveUserGroup(id, name, (TenantId)tenantId.get(), isAllUsersGroup);
            }
        });
    }
}

