/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.tenant;

import de.justsoftware.drive.business.kafka.KafkaConsumerConfig;
import de.justsoftware.drive.business.tenant.TenantIdDeserializer;
import de.justsoftware.drive.common.tenant.model.TenantId;
import java.util.Map;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;

@Configuration
@EnableKafka
@Profile(value={"!test"})
public class KafkaTenantConfiguration {
    private final KafkaConsumerConfig _kafkaConsumerConfig;

    KafkaTenantConfiguration(KafkaConsumerConfig kafkaConsumerConfig) {
        this._kafkaConsumerConfig = kafkaConsumerConfig;
    }

    public ConsumerFactory<TenantId, String> createConsumerFactory() {
        Map props = this._kafkaConsumerConfig.defaultConsumerConfig();
        props.put("group.id", "just.drive.tenantConsumer");
        props.put("spring.deserializer.key.delegate.class", TenantIdDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", StringDeserializer.class);
        return new DefaultKafkaConsumerFactory(props);
    }

    @Bean
    public ConcurrentKafkaListenerContainerFactory<TenantId, String> tenantListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.createConsumerFactory());
        return factory;
    }
}

