/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.settings;

import de.justsoftware.drive.business.common.CommonConfigurationProperties;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.settings.model.SettingsBO;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.persistence.settings.SettingsDAO;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SettingsServiceImpl
implements SettingsService {
    private final SettingsDAO _settingsDAO;
    private final CommonConfigurationProperties _commonConfig;

    @Autowired
    public SettingsServiceImpl(SettingsDAO settingsDAO, CommonConfigurationProperties commonConfig) {
        this._settingsDAO = settingsDAO;
        this._commonConfig = commonConfig;
    }

    public @Nullable SettingsBO getSettings(TenantId tenantId) {
        return this._settingsDAO.getSettings(tenantId);
    }

    public List<SettingsBO> getAllSettings() {
        return this._settingsDAO.getAllSettings();
    }

    public SettingsBO insertPublicLinksSettings(TenantId tenantId, boolean publicLinksEnabled) {
        SettingsBO existingSettings = this.getSettings(tenantId);
        if (existingSettings != null) {
            return this.insertSettings(tenantId, publicLinksEnabled, existingSettings.antivirusEnabled());
        }
        return this.insertSettings(tenantId, publicLinksEnabled, false);
    }

    @Transactional
    public SettingsBO insertAntivirusSettings(TenantId tenantId, boolean antivirusEnabled) {
        SettingsBO existingSettings = this.getSettings(tenantId);
        if (existingSettings != null) {
            return this.insertSettings(tenantId, existingSettings.publicLinksEnabled(), antivirusEnabled);
        }
        return this.insertSettings(tenantId, false, antivirusEnabled);
    }

    private SettingsBO insertSettings(TenantId tenantId, boolean publicLinksEnabled, boolean antivirusEnabled) {
        SettingsBO settings = new SettingsBO(tenantId, publicLinksEnabled, antivirusEnabled);
        this._settingsDAO.insert(settings);
        return this._settingsDAO.getSettings(settings.tenantId());
    }

    public boolean isPublicLinksEnabled(TenantId tenantId) {
        SettingsBO settings = this.getSettings(tenantId);
        return settings != null && settings.publicLinksEnabled();
    }

    public boolean isAntivirusEnabled(TenantId tenantId) {
        if (!this._commonConfig.isAntivirusEnabled()) {
            return false;
        }
        SettingsBO settings = this.getSettings(tenantId);
        return settings != null && settings.antivirusEnabled();
    }
}

