/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.server.business.impl;

import de.justsoftware.drive.business.server.business.AdaApiConnector;
import de.justsoftware.drive.common.tenant.model.TenantId;
import java.util.NoSuchElementException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;

@Service
public class AdaApiConnectorImpl
implements AdaApiConnector {
    private static final Logger LOG = LoggerFactory.getLogger(AdaApiConnectorImpl.class);
    private final RestClient _restClient;

    @Autowired
    public AdaApiConnectorImpl(@Value(value="${just-admin.internal.api.url}") String adaInternalApiUrl, RestClient.Builder restClientBuilder) {
        this._restClient = restClientBuilder.baseUrl(adaInternalApiUrl).build();
    }

    public Set<String> getTenantManagers(TenantId tenantId) {
        try {
            Set managerIds = (Set)this._restClient.get().uri("/tenant/manager/{role}", new Object[]{tenantId.asPermissionRole()}).accept(new MediaType[]{MediaType.APPLICATION_JSON}).retrieve().body((ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */);
            if (managerIds == null || managerIds.isEmpty()) {
                return Set.of();
            }
            return managerIds;
        }
        catch (NoSuchElementException | RestClientException e) {
            LOG.error("Could not get TenantManagers for {}", (Object)tenantId, (Object)e);
            return Set.of();
        }
    }
}

