/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.search.impl;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import de.justsoftware.drive.business.search.SearchVisibilityService;
import de.justsoftware.drive.common.authorization.model.Role;
import de.justsoftware.drive.common.authorization.model.StaticAction;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.model.AbstractId;
import de.justsoftware.drive.common.util.EntryCollectors;
import de.justsoftware.drive.common.util.EntryStream;
import de.justsoftware.permission.client.rest.PermissionRequestConnector;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchVisibilityServiceImpl
implements SearchVisibilityService {
    @VisibleForTesting
    final PermissionRequestConnector _permissionRequestConnector;

    @Autowired
    public SearchVisibilityServiceImpl(PermissionRequestConnector permissionRequestConnector) {
        this._permissionRequestConnector = permissionRequestConnector;
    }

    public ImmutableTable<ItemId, StaticAction, ImmutableSet<Role>> loadVisibilities(SetMultimap<ItemId, StaticAction> itemsAndActions) {
        ImmutableSetMultimap visibilitiesFromPermission = this.loadVisibilitiesFromPermission(itemsAndActions);
        return (ImmutableTable)EntryStream.from(itemsAndActions).collect(ImmutableTable.toImmutableTable(Map.Entry::getKey, Map.Entry::getValue, entry -> {
            ItemId itemId = (ItemId)entry.getKey();
            return visibilitiesFromPermission.get((Object)itemId);
        }));
    }

    private ImmutableSetMultimap<ItemId, Role> loadVisibilitiesFromPermission(SetMultimap<ItemId, StaticAction> itemsAndActions) {
        ImmutableSet permissionRelatedActions = (ImmutableSet)EntryStream.from(itemsAndActions).filterValue(arg_0 -> StaticAction.DOCUMENT_READ.equals(arg_0)).mapKey(AbstractId::getId).keys().collect(ImmutableSet.toImmutableSet());
        ImmutableSetMultimap visibilities = this._permissionRequestConnector.visibility((Iterable)permissionRelatedActions);
        return (ImmutableSetMultimap)EntryStream.from((Multimap)visibilities).mapKey(ItemId::new).mapValue(Role::valueOf).collect(EntryCollectors.toImmutableSetMultimap());
    }
}

