/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.kafka;

import de.justsoftware.drive.business.kafka.KafkaConsumerConfig;
import de.justsoftware.drive.common.file.model.StorageId;
import java.util.Map;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;

@Configuration
@EnableKafka
@Profile(value={"!test"})
public class VirusScanKafkaConfiguration {
    private final KafkaConsumerConfig _kafkaConsumerConfig;

    VirusScanKafkaConfiguration(KafkaConsumerConfig kafkaConsumerConfig) {
        this._kafkaConsumerConfig = kafkaConsumerConfig;
    }

    public ConsumerFactory<StorageId, String> createConsumerFactory() {
        Map props = this._kafkaConsumerConfig.defaultConsumerConfig();
        props.put("group.id", "just.virus.scan.resultConsumer");
        props.put("spring.deserializer.key.delegate.class", StringDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", StringDeserializer.class);
        return new DefaultKafkaConsumerFactory(props);
    }

    @Bean
    public ConcurrentKafkaListenerContainerFactory<StorageId, String> virusScanResultListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.createConsumerFactory());
        return factory;
    }
}

