/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.judo.judoclient;

import com.google.common.base.Charsets;
import de.justsoftware.drive.business.judo.judoclient.model.Keyable;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.Serializer;
import org.jspecify.annotations.Nullable;

public abstract class KafkaClient<T extends Keyable> {
    private final @Nullable Producer<String, String> _producer;
    private final String _topic;
    private final String _keyPrefix;
    private final Serializer<T> _serializer;

    public KafkaClient(@Nullable Producer<String, String> kafkaProducer, String keyPrefix, String topic, Serializer<T> serializer) {
        this._producer = kafkaProducer;
        this._topic = topic;
        this._keyPrefix = keyPrefix;
        this._serializer = serializer;
    }

    public abstract void assertValid(T var1) throws AssertionError;

    public void dispatch(T t) {
        this.assertValid(t);
        byte[] serialized = this._serializer.serialize(this._topic, t);
        this.send(this._keyPrefix + t.key(), new String(serialized, Charsets.UTF_8));
    }

    private void send(String key, @Nullable String value) {
        if (this._producer != null) {
            this._producer.send(new ProducerRecord(this._topic, (Object)key, (Object)value));
        }
    }
}

