/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.judo;

import de.justsoftware.drive.business.judo.JudoClient;
import de.justsoftware.drive.common.file.model.PreviewId;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import java.util.Set;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClient;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class JudoClient {
    public static final String JUST_DOCUMENT_PREVIEW_DELETION_TOPIC = "just.documents.preview.deletion";
    private static final String URL_DOCUMENT_API_DOCUMENTS = "/api/v1/documents";
    private static final Logger LOG = LogManager.getLogger(JudoClient.class);
    private static final int JUDO_LONG_READ_TIMEOUT_IN_MINUTES = 120;
    private static final int JUDO_DEFAUT_TIMEOUT_IN_SECONDS = 10;
    private final Producer<String, String> _producer;
    private final String _judoUrl;
    private final RestClient _defaultRestClient;
    private final RestClient.Builder _restClientBuilder;

    @Autowired
    public JudoClient(Producer<String, String> producer, RestClient.Builder restClientBuilder, @Value(value="${just.drive.judo.url}") String judoUrl) {
        this._producer = producer;
        this._judoUrl = judoUrl;
        this._restClientBuilder = restClientBuilder;
        this._defaultRestClient = this.createtRestClient(restClientBuilder, judoUrl, Duration.ofSeconds(10L), Duration.ofSeconds(10L));
    }

    private RestClient createtRestClient(RestClient.Builder restClientBuilder, String judoUrl, Duration readTimeout, Duration connectTimeout) {
        SimpleClientHttpRequestFactory requestFactory = new SimpleClientHttpRequestFactory();
        requestFactory.setReadTimeout(readTimeout);
        requestFactory.setConnectTimeout(connectTimeout);
        return restClientBuilder.baseUrl(judoUrl).requestFactory((ClientHttpRequestFactory)requestFactory).build();
    }

    public void deletePreview(PreviewId previewId) {
        LOG.info("Queueing preview deletion for {}", (Object)previewId);
        this._producer.send(new ProducerRecord("just.documents.preview.deletion", (Object)previewId.toString(), null));
    }

    public void deletePreviews(Set<PreviewId> documentIds) {
        documentIds.forEach(arg_0 -> this.deletePreview(arg_0));
    }

    public boolean isAvailable() {
        return this._defaultRestClient.get().uri("/internal/monitoring/info", new Object[0]).retrieve().toBodilessEntity().getStatusCode().is2xxSuccessful();
    }

    public void deletePreviewSources() {
        RestClient restClient = this.createtRestClient(this._restClientBuilder, this._judoUrl, Duration.ofMinutes(120L), Duration.ofSeconds(10L));
        restClient.delete().uri("/api/v1/documents/deletePreviewSources", new Object[0]).retrieve().toBodilessEntity();
    }

    public JudoDocumentInputStream getDocumentResource(PreviewId previewId, String relativeResourcePath) throws JudoApiException {
        return this.fetchContent("/" + (String)previewId.getId() + "/HTML/" + relativeResourcePath);
    }

    private JudoDocumentInputStream fetchContent(String target) throws JudoApiException {
        try {
            URL url = new URL(this._judoUrl + "/content" + target);
            URLConnection connection = url.openConnection();
            return JudoDocumentInputStream.from((URLConnection)connection);
        }
        catch (MalformedURLException e) {
            throw new JudoApiException("Target URL is invalid : " + target, (Exception)e);
        }
        catch (IOException e) {
            throw new JudoApiException("Error fetching document from : " + target, (Exception)e);
        }
    }
}

