/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.item.impl;

import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.event.ItemVisibilitiesChangedEvent;
import de.justsoftware.drive.business.item.ItemWriteService;
import de.justsoftware.drive.common.item.model.ItemId;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.messaging.handler.annotation.Header;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
public class PermissionItemListener {
    private static final Logger LOG = LoggerFactory.getLogger(PermissionItemListener.class);
    private static final String TOPIC = "just.permission.item";
    private final ItemWriteService _itemWriteService;
    private final EventBus _eventBus;

    public PermissionItemListener(ItemWriteService itemWriteService, EventBus eventBus) {
        this._itemWriteService = itemWriteService;
        this._eventBus = eventBus;
    }

    @KafkaListener(id="just.drive.permissionItemListener", topics={"just.permission.item"}, containerFactory="permissionItemKafkaListenerContainerFactory")
    public void listen(@Header(value="kafka_receivedMessageKey") ItemId itemId, @Payload(required=false) @Nullable String value) {
        if (value == null) {
            LOG.info("Received deletion for item {} in  just.permission.item. Marking it as deleted", (Object)itemId);
            Set<ItemId> itemIds = Set.of(itemId);
            this._itemWriteService.markAsDeleted(itemIds);
            this._eventBus.post((Object)new ItemVisibilitiesChangedEvent(itemIds));
        } else {
            LOG.info("Received info for item {} in  just.permission.item. Marking it as active if it was deleted.", (Object)itemId);
            this._itemWriteService.markAsActiveIfDeleted(Set.of(itemId));
        }
    }
}

