/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.item.impl;

import de.justsoftware.drive.business.kafka.KafkaConsumerConfig;
import de.justsoftware.drive.business.kafka.serde.ItemIdDeserializer;
import de.justsoftware.drive.common.item.model.ItemId;
import java.util.Map;
import org.apache.kafka.common.serialization.StringDeserializer;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.kafka.annotation.EnableKafka;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaConsumerFactory;

@Configuration
@EnableKafka
@Profile(value={"!test"})
public class PermissionItemKafkaConfiguration {
    private final KafkaConsumerConfig _kafkaConsumerConfig;

    PermissionItemKafkaConfiguration(KafkaConsumerConfig kafkaConsumerConfig) {
        this._kafkaConsumerConfig = kafkaConsumerConfig;
    }

    private ConsumerFactory<ItemId, String> createConsumerFactory() {
        Map props = this._kafkaConsumerConfig.defaultConsumerConfig();
        props.put("group.id", "just.drive.permissionItemConsumer");
        props.put("spring.deserializer.key.delegate.class", ItemIdDeserializer.class);
        props.put("spring.deserializer.value.delegate.class", StringDeserializer.class);
        return new DefaultKafkaConsumerFactory(props);
    }

    @Bean
    public ConcurrentKafkaListenerContainerFactory<ItemId, String> permissionItemKafkaListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.createConsumerFactory());
        return factory;
    }
}

