/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.item.impl;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.document.ItemLockService;
import de.justsoftware.drive.business.document.ItemLockedException;
import de.justsoftware.drive.business.event.ItemsPurgeEvent;
import de.justsoftware.drive.business.file.FileStorageService;
import de.justsoftware.drive.business.file.VirusScannerService;
import de.justsoftware.drive.business.item.ItemPurgeService;
import de.justsoftware.drive.business.judo.JudoClient;
import de.justsoftware.drive.business.shares.SharesService;
import de.justsoftware.drive.common.file.model.FilePreviewInfoBO;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.PreviewId;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.persistence.change.ChangeDAO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.document.DocumentVersionDAO;
import de.justsoftware.drive.persistence.file.FileVersionDAO;
import de.justsoftware.drive.persistence.file.FileVersionPreviewDAO;
import de.justsoftware.drive.persistence.folder.FolderVersionDAO;
import de.justsoftware.drive.persistence.folder.SubFolderDAO;
import de.justsoftware.drive.persistence.item.ItemDAO;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import java.util.DoubleSummaryStatistics;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
class ItemPurgeServiceImpl
implements ItemPurgeService {
    private static final Logger LOG = LoggerFactory.getLogger(ItemPurgeServiceImpl.class);
    private static final double MB_FACTOR = 1000000.0;
    private final ItemDAO _itemDAO;
    private final DocumentDAO _documentDAO;
    private final SubFolderDAO _subFolderDAO;
    private final DocumentVersionDAO _documentVersionDAO;
    private final TransactionSupport _transactionSupport;
    private final ItemLockService _itemLockService;
    private final ChangeDAO _changeDAO;
    private final JudoClient _judoClient;
    private final FileStorageService _fileStorageService;
    private final FileVersionPreviewDAO _fileVersionPreviewDAO;
    private final FolderVersionDAO _folderVersionDAO;
    private final FileVersionDAO _fileVersionDAO;
    private final EventBus _eventBus;
    private final SharesService _sharesService;
    private final VirusScannerService _virusScannerService;

    public ItemPurgeServiceImpl(DocumentDAO documentDAO, SubFolderDAO subFolderDAO, DocumentVersionDAO documentVersionDAO, TransactionSupport transactionSupport, ItemLockService itemLockService, ChangeDAO changeDAO, JudoClient judoClient, FileStorageService fileStorageService, FileVersionPreviewDAO fileVersionPreviewDAO, ItemDAO itemDAO, FolderVersionDAO folderVersionDAO, FileVersionDAO fileVersionDAO, SharesService sharesService, EventBus eventBus, VirusScannerService virusScannerService) {
        this._documentDAO = documentDAO;
        this._subFolderDAO = subFolderDAO;
        this._documentVersionDAO = documentVersionDAO;
        this._transactionSupport = transactionSupport;
        this._itemLockService = itemLockService;
        this._changeDAO = changeDAO;
        this._judoClient = judoClient;
        this._fileStorageService = fileStorageService;
        this._fileVersionPreviewDAO = fileVersionPreviewDAO;
        this._itemDAO = itemDAO;
        this._folderVersionDAO = folderVersionDAO;
        this._fileVersionDAO = fileVersionDAO;
        this._sharesService = sharesService;
        this._eventBus = eventBus;
        this._virusScannerService = virusScannerService;
    }

    public Set<ItemId> purge(Set<ItemId> items) {
        if (items.isEmpty()) {
            return Set.of();
        }
        if (!this._judoClient.isAvailable()) {
            LOG.error("Trying to purge items, but Judo is not available. No items are purged.");
            return Set.of();
        }
        if (!this._fileStorageService.isFileStorageAvailable()) {
            LOG.error("Trying to purge items, but file storage is not available. Not items are purged.");
            return Set.of();
        }
        ImmutableMap rootFolderIds = this._sharesService.getRootFolderIds(items);
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)items.size());
        items = this._itemDAO.filterDeleted(items);
        for (ItemId itemId : items) {
            try {
                List allVersionsForItem = this._fileVersionDAO.getAllVersionsForItem(itemId);
                Set onlyReferencedByItem = this._fileVersionDAO.getExclusiveStorageIdsForItem(itemId);
                this._itemLockService.acquireAndExecute(itemId, this.purgeDataFromDatabaseFor(itemId, allVersionsForItem, onlyReferencedByItem));
                DoubleSummaryStatistics statistics = allVersionsForItem.stream().mapToDouble(bo -> (double)bo.getFileSize() / 1000000.0).summaryStatistics();
                builder.add((Object)itemId);
                if (statistics.getCount() > 0L) {
                    LOG.info("Deleted {} files for item '{}'. Potentially freeing up {} MB.", new Object[]{statistics.getCount(), itemId, Math.floor(statistics.getSum())});
                    continue;
                }
                LOG.info("No files found for item '{}'.", (Object)itemId);
            }
            catch (ItemLockedException e) {
                LOG.error("Could not lock item '{}'. Nothing will be deleted for the item this time.", (Object)itemId);
            }
        }
        this._transactionSupport.doInTransaction(() -> ((FileVersionPreviewDAO)this._fileVersionPreviewDAO).deleteAllPreviewOrphansWithoutVersions());
        this._eventBus.post((Object)new ItemsPurgeEvent(items, rootFolderIds));
        return builder.build();
    }

    private Supplier<Boolean> purgeDataFromDatabaseFor(ItemId itemId, List<FileVersionBO> allVersionsForItem, Set<StorageId> exclusiveStorageIds) {
        return () -> (Boolean)this._transactionSupport.doInTransaction(() -> {
            Set judoPreviewIdsToDelete = this.getJudoPreviewIds(exclusiveStorageIds);
            this._documentDAO.prepareDeleteItem(itemId);
            this._subFolderDAO.deleteAllForItem(itemId);
            this._fileVersionDAO.deleteAllFromItem(itemId);
            this._folderVersionDAO.deleteAllForItem(itemId);
            this._changeDAO.deleteAllChangesForItem(itemId);
            this._documentDAO.deleteAllWithoutVersions();
            this._itemDAO.deleteItems(Set.of(itemId));
            this._fileVersionPreviewDAO.deletePreviews(exclusiveStorageIds);
            this._virusScannerService.deleteVirusScan(exclusiveStorageIds);
            this._transactionSupport.doAfterTransaction(() -> {
                this.deleteFromStorageServer(allVersionsForItem, exclusiveStorageIds);
                this._judoClient.deletePreviews(judoPreviewIdsToDelete);
            });
            return true;
        });
    }

    private Set<PreviewId> getJudoPreviewIds(Set<StorageId> storageIds) {
        ImmutableMap previewInfos = this._fileVersionPreviewDAO.getPreviewInfos(storageIds);
        Set<PreviewId> externalDocumentIds = previewInfos.values().stream().map(FilePreviewInfoBO::getPreviewId).filter(Objects::nonNull).collect(Collectors.toUnmodifiableSet());
        return externalDocumentIds;
    }

    private void deleteFromStorageServer(List<FileVersionBO> allVersionsForItem, Set<StorageId> onlyReferencedByItem) {
        ImmutableListMultimap asMap = Multimaps.index(allVersionsForItem, FileVersionBO::getStorageId);
        Multimap deleteStorageIds = Multimaps.filterKeys((Multimap)asMap, onlyReferencedByItem::contains);
        this._fileStorageService.deleteFilesWithTransactionLog(deleteStorageIds, FileStorageService.DeletionMode.FORCE_DELETE_REFERENCED_FILES);
    }
}

