/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.folder;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import de.justsoftware.drive.business.folder.CurrentVersionData;
import de.justsoftware.drive.business.folder.FolderService;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.folder.model.FolderVersionBO;
import de.justsoftware.drive.persistence.change.ChangeDAO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.file.DocumentSupportDAO;
import de.justsoftware.drive.persistence.file.FileVersionDAO;
import de.justsoftware.drive.persistence.folder.FolderDAO;
import de.justsoftware.drive.persistence.folder.FolderVersionDAO;
import de.justsoftware.drive.persistence.folder.SubFolderDAO;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class FolderServiceImpl
implements FolderService {
    private static final Logger LOG = LoggerFactory.getLogger(FolderServiceImpl.class);
    final FolderDAO _folderDAO;
    final FolderVersionDAO _folderVersionDAO;
    final FileVersionDAO _fileVersionDAO;
    final ChangeDAO _changeDAO;
    final DocumentDAO _documentDAO;
    final SubFolderDAO _subFolderDAO;
    final DocumentSupportDAO _documentSupportDAO;

    @Autowired
    public FolderServiceImpl(DocumentDAO documentDAO, FolderDAO folderDAO, SubFolderDAO subFolderDAO, FolderVersionDAO folderVersionDAO, FileVersionDAO fileVersionDAO, ChangeDAO changeDAO, DocumentSupportDAO documentSupportDAO) {
        this._documentDAO = documentDAO;
        this._folderDAO = folderDAO;
        this._subFolderDAO = subFolderDAO;
        this._folderVersionDAO = folderVersionDAO;
        this._fileVersionDAO = fileVersionDAO;
        this._changeDAO = changeDAO;
        this._documentSupportDAO = documentSupportDAO;
    }

    public ImmutableListMultimap<DocumentVersionId, DocumentVersionBO> getFolderContents(Set<DocumentVersionId> folderVersions) {
        ImmutableSetMultimap children = this._subFolderDAO.getSubFoldersByIds(folderVersions);
        ImmutableSet childIds = ImmutableSet.copyOf((Collection)children.values());
        ImmutableMap documentVersions = this._documentSupportDAO.getDocumentVersionsByIds((Set)childIds);
        Multimap result = Multimaps.transformValues((Multimap)children, arg_0 -> ((ImmutableMap)documentVersions).get(arg_0));
        return ImmutableListMultimap.copyOf((Multimap)Multimaps.filterValues((Multimap)result, Objects::nonNull));
    }

    public ImmutableMap<DocumentVersionId, FolderVersionBO> getFolderVersionsByIds(Set<DocumentVersionId> ids) {
        return this._folderVersionDAO.getFolderVersionsByIds(ids);
    }

    public ImmutableMap<DocumentId, DocumentVersionId> getCurrentVersionsOfDocuments(Set<DocumentId> ids) {
        return ImmutableMap.copyOf((Map)Maps.transformValues((Map)this.getCurrentVersionDataOfDocuments(ids), CurrentVersionData::getDocumentVersionId));
    }

    public ImmutableMap<DocumentId, CurrentVersionData> getCurrentVersionDataOfDocuments(Set<DocumentId> ids) {
        ImmutableListMultimap currentPaths;
        if (ids.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableBiMap lastVersions = this._documentDAO.getLastVersions(ids);
        ImmutableListMultimap paths = this._documentSupportDAO.getPath((Set)ImmutableSet.copyOf((Collection)lastVersions.values()));
        ImmutableSet changeIds = FluentIterable.from((Iterable)paths.asMap().values()).transform(i -> (DocumentVersionId)i.iterator().next()).toSet();
        ImmutableMap changes = this._changeDAO.getChangesByIds((Set)changeIds);
        ImmutableSet items = FluentIterable.from((Iterable)changes.values()).transform(ChangeBO.GET_ITEM_ID).toSet();
        ImmutableMap newestChanges = this._changeDAO.getNewestChangePerItem((Set)items);
        ImmutableMap newestChangePerId = FluentIterable.from((Iterable)newestChanges.values()).uniqueIndex(ChangeBO::getId);
        ImmutableMap result = FolderServiceImpl.filterCurrentLastVersions((Map)lastVersions, (ListMultimap)paths, (ImmutableMap)newestChangePerId);
        Sets.SetView possiblyDeleted = Sets.difference((Set)lastVersions.keySet(), (Set)result.keySet());
        if (possiblyDeleted.isEmpty()) {
            return result;
        }
        ImmutableBiMap currentLastVersions = this._documentDAO.getLastVersions((Set)possiblyDeleted);
        ImmutableMap updated = FolderServiceImpl.filterCurrentLastVersions((Map)currentLastVersions, (ListMultimap)(currentPaths = this._documentSupportDAO.getPath((Set)ImmutableSet.copyOf((Collection)currentLastVersions.values()))), (ImmutableMap)newestChangePerId);
        if (updated.isEmpty()) {
            return result;
        }
        LOG.info("got updated current versions {}", (Object)updated.keySet());
        return ImmutableMap.builder().putAll((Map)result).putAll((Map)updated).build();
    }

    private static ImmutableMap<DocumentId, CurrentVersionData> filterCurrentLastVersions(Map<DocumentId, DocumentVersionId> lastVersions, ListMultimap<DocumentVersionId, DocumentVersionId> paths, ImmutableMap<DocumentVersionId, ChangeBO> newestChangePerId) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        lastVersions.forEach((documentId, documentVersionId) -> {
            List path = paths.get(documentVersionId);
            if (path.isEmpty()) {
                return;
            }
            ChangeBO newestChange = (ChangeBO)newestChangePerId.get(path.get(0));
            if (newestChange != null) {
                result.put(documentId, (Object)new CurrentVersionData(documentId, documentVersionId, ImmutableSet.copyOf((Collection)path), newestChange));
            }
        });
        return result.build();
    }

    public ImmutableMap<DocumentId, FolderVersionBO> getNewestVersionsByIds(Set<DocumentId> folderIds) {
        ImmutableBiMap versionMap = this._documentDAO.getLastVersions(folderIds);
        ImmutableMap newestVersions = this._folderVersionDAO.getFolderVersionsByIds((Set)ImmutableSet.copyOf((Collection)versionMap.values()));
        return FluentIterable.from((Iterable)newestVersions.values()).uniqueIndex(DocumentVersionBO.GET_DOCUMENT_ID);
    }

    public ImmutableMap<DocumentId, DocumentVersionId> getLastVersionsOfDocuments(Set<DocumentId> ids) {
        return this._documentDAO.getLastVersions(ids);
    }

    public ImmutableListMultimap<DocumentVersionId, DocumentVersionId> getPath(Set<DocumentVersionId> ids) {
        return this._documentSupportDAO.getPath(ids);
    }

    public ImmutableListMultimap<DocumentVersionId, FolderVersionBO> getPathBOs(Set<DocumentVersionId> ids) {
        ImmutableListMultimap pathIds = this.getPath(ids);
        Multimap pathIdsWithoutSelf = Multimaps.filterEntries((Multimap)pathIds, input -> !((DocumentVersionId)input.getKey()).equals(input.getValue()));
        ImmutableMap folderVersionById = this.getFolderVersionsByIds((Set)ImmutableSet.copyOf((Collection)pathIdsWithoutSelf.values()));
        return ImmutableListMultimap.copyOf((Multimap)Multimaps.filterValues((Multimap)Multimaps.transformValues((Multimap)pathIdsWithoutSelf, (Function)Functions.forMap((Map)folderVersionById, null)), (Predicate)Predicates.notNull()));
    }
}

