/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.eventbus.EventBus;
import de.justsoftware.drive.business.document.DocumentService;
import de.justsoftware.drive.business.event.FileVirusScanCleanEvent;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.file.VirusScannerService;
import de.justsoftware.drive.business.kafka.NotificationConnector;
import de.justsoftware.drive.business.kafka.VirusScanKafkaDto;
import de.justsoftware.drive.business.kafka.VirusScanKafkaProducer;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.VirusScanBo;
import de.justsoftware.drive.common.file.model.VirusScanStatus;
import de.justsoftware.drive.common.file.model.VirusScanUpdateStatusBo;
import de.justsoftware.drive.common.person.model.PersonId;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.filepersistence.file.FileStorageDAO;
import de.justsoftware.drive.persistence.file.VirusScanDAO;
import de.justsoftware.drive.persistence.transaction.TransactionSupport;
import de.justsoftware.drive.rest.mapping.VirusScanResultIssueDto;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class VirusScannerServiceImpl
implements VirusScannerService {
    private static final Logger LOG = LoggerFactory.getLogger(VirusScannerServiceImpl.class);
    private final VirusScanKafkaProducer _producer;
    private final VirusScanDAO _virusScanDAO;
    private final EventBus _eventBus;
    private final FileService _fileService;
    private final SettingsService _settingsService;
    private final NotificationConnector _notificationConnector;
    private final FileStorageDAO _fileStorageDAO;
    private final DocumentService _documentService;
    private final TransactionSupport _transactionSupport;

    @Autowired
    public VirusScannerServiceImpl(VirusScanKafkaProducer producer, VirusScanDAO virusScanDAO, EventBus eventBus, FileService fileService, SettingsService settingsService, NotificationConnector notificationConnector, FileStorageDAO fileStorageDAO, DocumentService documentService, TransactionSupport transactionSupport) {
        this._producer = producer;
        this._virusScanDAO = virusScanDAO;
        this._eventBus = eventBus;
        this._fileService = fileService;
        this._settingsService = settingsService;
        this._notificationConnector = notificationConnector;
        this._fileStorageDAO = fileStorageDAO;
        this._documentService = documentService;
        this._transactionSupport = transactionSupport;
    }

    public boolean sendFileToVirusScan(StorageId storageId, TenantId tenantId) {
        VirusScanBo virusScanBo = this._virusScanDAO.findVirusScanStatus(storageId);
        if (virusScanBo == null) {
            this._virusScanDAO.addVirusScanRequestIfNotExists(storageId);
            if (this._settingsService.isAntivirusEnabled(tenantId)) {
                this.sendToQueue(storageId);
                return true;
            }
        }
        return false;
    }

    public void rescanFile(DocumentVersionId fileVersionId, TenantId tenantId) {
        FileVersionBO fileVersionBo = this._fileService.getSingleVersionById(fileVersionId);
        if (fileVersionBo == null) {
            throw new IllegalArgumentException("FileVersionBO not found");
        }
        StorageId storageId = fileVersionBo.getStorageId();
        VirusScanBo virusScanBo = this._virusScanDAO.findVirusScanStatus(storageId);
        if (virusScanBo == null) {
            throw new IllegalArgumentException("VirusScanStatus not found");
        }
        boolean reScanPossible = virusScanBo.getVirusScanStatus() != VirusScanStatus.QUEUED && virusScanBo.getVirusScanStatus() != VirusScanStatus.PROCESSING;
        boolean antivirusEnabled = this._settingsService.isAntivirusEnabled(tenantId);
        if (antivirusEnabled && reScanPossible) {
            LOG.info("Sending storageId {} and current status {} to be rescanned by Judo.", (Object)storageId, (Object)virusScanBo.getVirusScanStatus());
            this.sendToQueue(virusScanBo.getStorageId());
        } else {
            LOG.info("Skipping rescan of storageId {} because antivirusEnabled: {} or status: {}", new Object[]{storageId, antivirusEnabled, virusScanBo.getVirusScanStatus()});
        }
    }

    private void sendToQueue(StorageId storageId) {
        String storageFileUrl = this._fileStorageDAO.getUrl(storageId);
        this._virusScanDAO.setVirusScanStatus(new VirusScanBo(storageId, VirusScanStatus.QUEUED, null, null));
        this._transactionSupport.doAfterTransaction(() -> this._producer.publish(storageId, new VirusScanKafkaDto((String)storageId.getId(), storageFileUrl)));
    }

    public void handleVirusScanResult(VirusScanBo scanResult) {
        StorageId storageId = scanResult.getStorageId();
        this._virusScanDAO.setVirusScanStatus(scanResult);
        if (scanResult.getVirusScanStatus().isClean()) {
            this._fileService.getFileVersionsByStorageId(storageId).stream().max(Comparator.comparingInt(DocumentVersionBO::getVersion)).ifPresent(version -> this._eventBus.post((Object)new FileVirusScanCleanEvent(version.getDocumentId(), version.getId())));
        } else if (scanResult.getVirusScanStatus() == VirusScanStatus.INFECTED) {
            List fileVersions = this._fileService.getFileVersionsByStorageId(storageId);
            Map<DocumentId, Optional<FileVersionBO>> newestVersionsByDocumentId = fileVersions.stream().collect(Collectors.groupingBy(DocumentVersionBO::getDocumentId, Collectors.maxBy(Comparator.comparingInt(DocumentVersionBO::getVersion))));
            newestVersionsByDocumentId.forEach((documentId, optionalFileVersion) -> optionalFileVersion.ifPresent(fv -> {
                if (!this._documentService.isDeleted(documentId) && fv.getTenantId() != null && this._settingsService.isAntivirusEnabled(fv.getTenantId())) {
                    this._notificationConnector.sendVirusFoundNotification(fv.getTenantId(), fv.getName());
                } else {
                    LOG.info("Virus found in deleted or tenant-less or antivirus disabled document {}, documentVersionId: {}", (Object)fv.getName(), (Object)fv.getId());
                }
            }));
        }
    }

    public void deleteVirusScan(Set<StorageId> storageIds) {
        this._virusScanDAO.deleteVirusScanStatus(storageIds);
    }

    public void enqueueUnscannedFiles() {
        int virusScanBatchSize = 500;
        int maxQueuedVirusScans = 100;
        if (this._virusScanDAO.countQueuedVirusScans() < 100) {
            this._virusScanDAO.findAllWithStatusNotScannedLatestFirst(500).forEach(arg_0 -> this.sendToQueue(arg_0));
        }
    }

    public List<VirusScanResultIssueDto> getIssues(TenantId tenantId) {
        return this._fileService.getVirusScanIssues(tenantId);
    }

    public void overrideVirusScanStatus(DocumentVersionId fileVersionId, VirusScanStatus newStatus, PersonId personId) {
        FileVersionBO fileVersion = this._fileService.getSingleVersionById(fileVersionId);
        if (fileVersion == null) {
            throw new IllegalArgumentException("fileVersion not found");
        }
        StorageId storageId = fileVersion.getStorageId();
        VirusScanBo virusScanBo = this._virusScanDAO.findVirusScanStatus(storageId);
        if (virusScanBo == null) {
            throw new IllegalArgumentException("VirusScanBo not found");
        }
        VirusScanStatus oldStatus = virusScanBo.getVirusScanStatus();
        if (!oldStatus.requiresAttention()) {
            throw new IllegalCallerException("Can't change the status of " + String.valueOf(fileVersionId) + " to status " + String.valueOf(newStatus) + " because the current status is " + String.valueOf(oldStatus));
        }
        this._virusScanDAO.overrideVirusScanStatus(new VirusScanUpdateStatusBo(storageId, newStatus, personId));
    }
}

