/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.eventbus.EventBus;
import com.google.common.io.ByteSource;
import de.justsoftware.drive.business.event.DocumentMetadataChangedEvent;
import de.justsoftware.drive.business.file.FileService;
import de.justsoftware.drive.business.file.FileServiceImpl;
import de.justsoftware.drive.business.file.VirusFoundException;
import de.justsoftware.drive.business.file.VirusScanFailedException;
import de.justsoftware.drive.business.file.VirusScanNotCompletedException;
import de.justsoftware.drive.business.item.ItemReadService;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.VideoTeaserId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.VirusScanStatus;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.filepersistence.file.FileStorageDAO;
import de.justsoftware.drive.persistence.document.DocumentDAO;
import de.justsoftware.drive.persistence.file.FileDAO;
import de.justsoftware.drive.persistence.file.FileVersionDAO;
import de.justsoftware.drive.rest.mapping.VirusScanResultIssueDto;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FileServiceImpl
implements FileService {
    final FileDAO _fileDAO;
    final FileVersionDAO _fileVersionDAO;
    final FileStorageDAO _fileStorageDao;
    final DocumentDAO _documentDAO;
    final EventBus _eventBus;
    final SettingsService _settingsService;
    final ItemReadService _itemReadService;

    @Autowired
    public FileServiceImpl(FileDAO fileDAO, FileVersionDAO fileVersionDAO, DocumentDAO documentDAO, FileStorageDAO fileStorageDAO, EventBus eventBus, SettingsService settingsService, ItemReadService itemReadService) {
        this._fileDAO = fileDAO;
        this._fileVersionDAO = fileVersionDAO;
        this._documentDAO = documentDAO;
        this._fileStorageDao = fileStorageDAO;
        this._eventBus = eventBus;
        this._settingsService = settingsService;
        this._itemReadService = itemReadService;
    }

    public @Nullable FileVersionBO getLastFileVersion(DocumentId fileId) {
        DocumentVersionId version = (DocumentVersionId)this._documentDAO.getLastVersions((Set)ImmutableSet.of((Object)fileId)).get((Object)fileId);
        if (version == null) {
            return null;
        }
        return (FileVersionBO)this._fileVersionDAO.getByIds((Set)ImmutableSet.of((Object)version)).get((Object)version);
    }

    public ByteSource getFileByteSource(FileVersionBO fileVersion) throws VirusScanNotCompletedException {
        this.checkVirusScanStatus(fileVersion);
        return this._fileStorageDao.load(fileVersion.getStorageId());
    }

    public ByteSource getFileByteSource(FileVersionBO fileVersion, @Nullable TenantId tenantId) throws VirusScanNotCompletedException {
        this.checkVirusScanStatus(fileVersion, tenantId);
        return this._fileStorageDao.load(fileVersion.getStorageId());
    }

    public void checkVirusScanStatus(FileVersionBO fileVersion) {
        this.checkVirusScanStatus(fileVersion, fileVersion.getTenantId());
    }

    private void checkVirusScanStatus(FileVersionBO fileVersion, @Nullable TenantId tenantId) {
        this.checkVirusScanStatus(fileVersion.getStorageId(), fileVersion.getVirusScanStatus(), tenantId);
    }

    public void checkVirusScanStatus(StorageId storageId, VirusScanStatus status, @Nullable TenantId tenantId) {
        boolean antivirusEnabled;
        boolean bl = antivirusEnabled = tenantId != null && this._settingsService.isAntivirusEnabled(tenantId);
        if (antivirusEnabled) {
            VirusScanNotCompletedException exception;
            switch (1.$SwitchMap$de$justsoftware$drive$common$file$model$VirusScanStatus[status.ordinal()]) {
                default: {
                    throw new MatchException(null, null);
                }
                case 1: 
                case 2: 
                case 3: {
                    VirusScanNotCompletedException virusScanNotCompletedException = null;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    VirusScanNotCompletedException virusScanNotCompletedException = new VirusScanNotCompletedException("Virus scan not yet completed for storageId: " + String.valueOf(storageId));
                    break;
                }
                case 7: {
                    VirusScanNotCompletedException virusScanNotCompletedException = new VirusFoundException("File storageId: " + String.valueOf(storageId) + " is infected");
                    break;
                }
                case 8: {
                    VirusScanNotCompletedException virusScanNotCompletedException = exception = new VirusScanFailedException("Virus scan for storageId: " + String.valueOf(storageId) + " failed");
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
    }

    public String getFileStorageUrl(FileVersionBO fileVersion) {
        this.checkVirusScanStatus(fileVersion);
        return this._fileStorageDao.getUrl(fileVersion.getStorageId());
    }

    public ImmutableMap<DocumentVersionId, FileVersionBO> getVersionsByIds(Set<DocumentVersionId> fileIds) {
        return this._fileVersionDAO.getByIds(fileIds);
    }

    public @Nullable FileVersionBO getSingleVersionById(DocumentVersionId fileVersionId) {
        return (FileVersionBO)this.getVersionsByIds((Set)ImmutableSet.of((Object)fileVersionId)).get((Object)fileVersionId);
    }

    public ImmutableListMultimap<DocumentId, FileVersionBO> getVersionsByDocumentIds(Set<DocumentId> ids) {
        return this._fileVersionDAO.getVersionsByDocumentIds(ids);
    }

    public ImmutableList<FileVersionBO> getLatestVersions(DocumentId id, int limit) {
        return this._fileVersionDAO.getLatestVersions(id, limit);
    }

    public void updateMetadata(DocumentId fileId, @Nullable String newTags) {
        this._documentDAO.updateMetadata(fileId, newTags);
        this._eventBus.post((Object)new DocumentMetadataChangedEvent(fileId));
    }

    public void setVideoTeaser(FileVersionBO fileVersionBO, VideoTeaserId videoTeaserId) {
        this._fileVersionDAO.setVideoTeaser(fileVersionBO.getId(), videoTeaserId);
    }

    public void deleteVideoTeaser(DocumentVersionId versionId) {
        this._fileVersionDAO.deleteVideoTeaser(versionId);
    }

    public List<FileVersionBO> getFileVersionsByStorageId(StorageId id) {
        return this._fileVersionDAO.getFileVersionsByStorageId(id);
    }

    public List<VirusScanResultIssueDto> getVirusScanIssues(TenantId tenantId) {
        return this._fileVersionDAO.findLatestFileVersionsWithVirusScanIssues(tenantId);
    }
}

