/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.file;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.ByteSource;
import de.justsoftware.drive.business.file.VirusFoundException;
import de.justsoftware.drive.business.file.VirusScanNotCompletedException;
import de.justsoftware.drive.common.document.model.DocumentId;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.document.model.VideoTeaserId;
import de.justsoftware.drive.common.file.model.FileVersionBO;
import de.justsoftware.drive.common.file.model.StorageId;
import de.justsoftware.drive.common.file.model.VirusScanStatus;
import de.justsoftware.drive.common.tenant.model.TenantId;
import de.justsoftware.drive.rest.mapping.VirusScanResultIssueDto;
import java.util.List;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public interface FileService {
    public ImmutableListMultimap<DocumentId, FileVersionBO> getVersionsByDocumentIds(Set<DocumentId> var1);

    public ImmutableList<FileVersionBO> getLatestVersions(DocumentId var1, int var2);

    public @Nullable FileVersionBO getLastFileVersion(DocumentId var1);

    public ImmutableMap<DocumentVersionId, FileVersionBO> getVersionsByIds(Set<DocumentVersionId> var1);

    public @Nullable FileVersionBO getSingleVersionById(DocumentVersionId var1);

    public ByteSource getFileByteSource(FileVersionBO var1) throws VirusScanNotCompletedException, VirusFoundException, IllegalArgumentException;

    public ByteSource getFileByteSource(FileVersionBO var1, @Nullable TenantId var2) throws VirusScanNotCompletedException, VirusFoundException, IllegalArgumentException;

    public void checkVirusScanStatus(FileVersionBO var1) throws VirusScanNotCompletedException, VirusFoundException, IllegalArgumentException;

    public void checkVirusScanStatus(StorageId var1, VirusScanStatus var2, @Nullable TenantId var3);

    public String getFileStorageUrl(FileVersionBO var1);

    public void updateMetadata(DocumentId var1, @Nullable String var2);

    public void setVideoTeaser(FileVersionBO var1, VideoTeaserId var2);

    public void deleteVideoTeaser(DocumentVersionId var1);

    public List<FileVersionBO> getFileVersionsByStorageId(StorageId var1);

    public List<VirusScanResultIssueDto> getVirusScanIssues(TenantId var1);
}

