/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.document.util;

import com.google.common.net.MediaType;
import de.justsoftware.drive.business.document.util.FileMetaInfoUtil;
import de.justsoftware.search.shared.model.SearchDriveFileType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;

@SuppressFBWarnings(value={"SE_BAD_FIELD", "SE_BAD_FIELD_STORE"}, justification="the members of this enum are not serialized")
public enum FileType {
    IMAGE(new MediaType[]{MediaType.ANY_IMAGE_TYPE}),
    AUDIO(new MediaType[]{MediaType.ANY_AUDIO_TYPE}),
    VIDEO(new MediaType[]{MediaType.ANY_VIDEO_TYPE}),
    TEXT_DOCUMENT(new MediaType[]{MediaType.MICROSOFT_WORD, MediaType.OOXML_DOCUMENT, MediaType.OPENDOCUMENT_TEXT, FileMetaInfoUtil.PLAIN_TEXT, MediaType.PLAIN_TEXT_UTF_8, FileMetaInfoUtil.ALTERNATIVE_MICROSOFT_WORD, FileMetaInfoUtil.OTT, FileMetaInfoUtil.RTF, FileMetaInfoUtil.PAGES}),
    PDF(new MediaType[]{MediaType.PDF}),
    SPREADSHEET(new MediaType[]{MediaType.MICROSOFT_EXCEL, MediaType.OOXML_SHEET, MediaType.OPENDOCUMENT_SPREADSHEET, FileMetaInfoUtil.ALTERNATIVE_MICROSOFT_EXCEL, FileMetaInfoUtil.OTS, FileMetaInfoUtil.NUMBERS}),
    PRESENTATION(new MediaType[]{MediaType.MICROSOFT_POWERPOINT, MediaType.OOXML_PRESENTATION, MediaType.OPENDOCUMENT_PRESENTATION, FileMetaInfoUtil.OTP, FileMetaInfoUtil.ALTERNATIVE_MICROSOFT_POWERPOINT, FileMetaInfoUtil.KEYNOTE}),
    FOLDER(new MediaType[]{FileMetaInfoUtil.FOLDER}),
    MISC(new MediaType[]{MediaType.ANY_TYPE});

    private final MediaType[] _correspondingMimeTypes;

    private FileType(MediaType ... correspondingMimeTypes) {
        this._correspondingMimeTypes = correspondingMimeTypes;
    }

    public boolean contains(MediaType mimeType) {
        return Arrays.stream(this._correspondingMimeTypes).anyMatch(arg_0 -> ((MediaType)mimeType).is(arg_0));
    }

    public SearchDriveFileType toSearchDriveFileType() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> SearchDriveFileType.IMAGE;
            case 1 -> SearchDriveFileType.AUDIO;
            case 2 -> SearchDriveFileType.VIDEO;
            case 3 -> SearchDriveFileType.TEXT_DOCUMENT;
            case 4 -> SearchDriveFileType.PDF;
            case 5 -> SearchDriveFileType.SPREADSHEET;
            case 6 -> SearchDriveFileType.PRESENTATION;
            case 7 -> SearchDriveFileType.FOLDER;
            case 8 -> SearchDriveFileType.MISC;
        };
    }
}

