/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.context;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import de.justsoftware.drive.business.context.DriveThreadPoolConfiguration;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@Configuration
public class DriveThreadPoolConfiguration
implements SchedulingConfigurer {
    private static final Logger LOG = LoggerFactory.getLogger(DriveThreadPoolConfiguration.class);
    @Autowired
    @Value(value="${just.drive.threadPoolSize:5}")
    private int _threadPoolSize;

    public void configureTasks(ScheduledTaskRegistrar taskRegistrar) {
        taskRegistrar.setScheduler((Object)this.taskExecutor());
    }

    @Bean(destroyMethod="shutdown")
    public ExecutorService taskExecutor() {
        ScheduledExecutorService executor = Executors.newScheduledThreadPool(this._threadPoolSize, new ThreadFactoryBuilder().setNameFormat("DriveThread-%d").build());
        return new LoggingScheduledExecutor(executor);
    }
}

