/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.common;

import java.nio.charset.StandardCharsets;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ExistsBuilder;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.stereotype.Service;

@ConditionalOnZookeeperEnabled
@Service
public class ZookeeperConfigService {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperConfigService.class);

    public void create(CuratorFramework zookeeperClient, String path, boolean value) {
        try {
            byte[] data = Boolean.toString(value).getBytes(StandardCharsets.UTF_8);
            ExistsBuilder existsBuilder = zookeeperClient.checkExists();
            Stat stat = (Stat)existsBuilder.forPath(path);
            if (stat == null) {
                ((ACLBackgroundPathAndBytesable)zookeeperClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(path, data);
                LOG.info("Created property {} with value {}", (Object)path, (Object)value);
            } else {
                LOG.debug("Property {} already exists, skipping update", (Object)path);
            }
        }
        catch (Exception e) {
            LOG.error("ZooKeeper create error for path {}: {}", (Object)path, (Object)e.getMessage());
        }
    }

    public void update(CuratorFramework zookeeperClient, String path, boolean value) {
        try {
            byte[] data = Boolean.toString(value).getBytes(StandardCharsets.UTF_8);
            ExistsBuilder existsBuilder = zookeeperClient.checkExists();
            Stat stat = (Stat)existsBuilder.forPath(path);
            if (stat == null) {
                throw new IllegalStateException("Property " + path + " does not exist");
            }
            zookeeperClient.setData().forPath(path, data);
            LOG.info("Updated property {} with value {}", (Object)path, (Object)value);
        }
        catch (Exception e) {
            LOG.error("ZooKeeper update error for path {}: {}", (Object)path, (Object)e.getMessage());
        }
    }
}

