/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.common;

import de.justsoftware.drive.business.common.CommonConfigurationProperties;
import de.justsoftware.drive.business.common.ZookeeperConfigService;
import de.justsoftware.drive.business.settings.SettingsService;
import de.justsoftware.drive.common.settings.model.SettingsBO;
import jakarta.annotation.PostConstruct;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.endpoint.event.RefreshEvent;
import org.springframework.cloud.zookeeper.ConditionalOnZookeeperEnabled;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@ConditionalOnZookeeperEnabled
@Service
public class VirusScanEnabledConfigService {
    private static final String ZK_VIRUS_SCANNER_ENABLED_PATH = "/just/config/just/drive/virusScannerEnabled";
    private static final String ZK_ANTIVIRUS_ENABLED_PATH = "/just/config/just/common/antivirusEnabled";
    private final ZookeeperConfigService _zookeeperConfigService;
    private final CuratorFramework _curatorFramework;
    private final SettingsService _settingsService;
    private final CommonConfigurationProperties _commonConfigurationProperties;

    @Autowired
    public VirusScanEnabledConfigService(ZookeeperConfigService zookeeperConfigService, CuratorFramework curatorFramework, SettingsService settingsService, CommonConfigurationProperties commonConfigurationProperties) {
        this._zookeeperConfigService = zookeeperConfigService;
        this._curatorFramework = curatorFramework;
        this._settingsService = settingsService;
        this._commonConfigurationProperties = commonConfigurationProperties;
    }

    @PostConstruct
    public void init() {
        this._zookeeperConfigService.create(this._curatorFramework, ZK_VIRUS_SCANNER_ENABLED_PATH, this.getAntivirusEnabled());
    }

    private boolean getAntivirusEnabled() {
        return this._commonConfigurationProperties.isAntivirusEnabled() && this._settingsService.getAllSettings().stream().anyMatch(SettingsBO::antivirusEnabled);
    }

    @EventListener
    public void antivirusEnabledChangedListener(RefreshEvent event) {
        if (event.getEvent() instanceof TreeCacheEvent && ((TreeCacheEvent)event.getEvent()).getData().getPath().equals(ZK_ANTIVIRUS_ENABLED_PATH)) {
            this.setZookeeperVirusScannerEnabled(this.getAntivirusEnabled());
        }
    }

    private void setZookeeperVirusScannerEnabled(boolean isVirusScanEnabled) {
        this._zookeeperConfigService.update(this._curatorFramework, ZK_VIRUS_SCANNER_ENABLED_PATH, isVirusScanEnabled);
    }

    public void triggerVirusScannerEnabled(boolean isAntivirusEnabled) {
        if (isAntivirusEnabled) {
            this.setZookeeperVirusScannerEnabled(true);
        } else if (this._settingsService.getAllSettings().stream().noneMatch(SettingsBO::antivirusEnabled)) {
            this.setZookeeperVirusScannerEnabled(false);
        }
    }
}

