/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.common;

import de.justsoftware.drive.business.common.ZookeeperUtil;
import de.justsoftware.jwtfilter.generator.JwtGenerator;
import de.justsoftware.jwtfilter.generator.JwtGenerators;
import de.justsoftware.jwtfilter.keys.JwtKeyLoadingException;
import de.justsoftware.jwtfilter.keys.SecretKeyCache;
import de.justsoftware.jwtfilter.verifier.JwtVerifier;
import de.justsoftware.jwtfilter.verifier.JwtVerifiers;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import org.apache.commons.lang3.RandomUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.NodeCache;
import org.apache.zookeeper.CreateMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SignedJwtConfig {
    private static final String ZOOKEEPER_PATH_FOR_PLAINTEXT_JWT_SIGNING_KEY = "/just/drive/jwt/jwtSigningKey";
    private static final Logger LOGGER = LoggerFactory.getLogger(SignedJwtConfig.class);
    private final SecretKeyCache _keyCache;
    private final CuratorFramework _zookeeperClient;
    private final NodeCache _zookeeperKeyLoadingCache;

    @Autowired
    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="we want to throw JwtKeyLoadingException here")
    public SignedJwtConfig(CuratorFramework zookeeperClient) throws JwtKeyLoadingException {
        this._zookeeperClient = zookeeperClient;
        this._zookeeperKeyLoadingCache = Optional.ofNullable(ZookeeperUtil.createNodeCache((CuratorFramework)zookeeperClient, (String)ZOOKEEPER_PATH_FOR_PLAINTEXT_JWT_SIGNING_KEY)).orElseThrow(() -> new JwtKeyLoadingException("Could not initialize Zookeeper Cache."));
        this._keyCache = new SecretKeyCache(() -> this.getJWTSignatureKey());
    }

    @Bean(name={"signedJwtVerifier"})
    public JwtVerifier provideJwtVerifier() {
        return JwtVerifiers.createSignedPlaintextTokenVerifier((SecretKeyCache)this._keyCache);
    }

    @Bean(name={"signedJwtGenerator"})
    public JwtGenerator provideJwtGenerator() {
        return JwtGenerators.createPlaintextSignedJwtGenerator((SecretKeyCache)this._keyCache);
    }

    private Optional<byte[]> getJWTSignatureKey() {
        byte[] keyBytes;
        ChildData currentData = this._zookeeperKeyLoadingCache.getCurrentData();
        if (currentData == null) {
            keyBytes = RandomUtils.nextBytes((int)32);
            ACLBackgroundPathAndBytesable createBuilder = (ACLBackgroundPathAndBytesable)this._zookeeperClient.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT);
            try {
                createBuilder.forPath(ZOOKEEPER_PATH_FOR_PLAINTEXT_JWT_SIGNING_KEY, keyBytes);
            }
            catch (Exception e) {
                LOGGER.error("Error storing JWT key in zookeeper", (Throwable)e);
                return Optional.empty();
            }
            LOGGER.debug("Stored key into zookeeper");
        } else {
            keyBytes = currentData.getData();
            LOGGER.debug("Loaded key from zookeeper");
        }
        return Optional.ofNullable(keyBytes);
    }
}

