/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.business.change;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import de.justsoftware.drive.business.change.ChangeTrigger;
import de.justsoftware.drive.common.change.model.ChangeBO;
import de.justsoftware.drive.common.document.model.DocumentVersionId;
import de.justsoftware.drive.common.item.model.ItemId;
import de.justsoftware.drive.common.person.model.PersonId;
import java.time.Instant;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class ChangeWithTriggers {
    private final ImmutableSet<? extends ChangeTrigger> _triggers;
    private final DocumentVersionId _changeId;
    private final ItemId _itemId;
    private final int _version;
    private final @Nullable PersonId _executedBy;
    private final Instant _changeDate;

    public ChangeWithTriggers(ChangeBO change, ImmutableSet<? extends ChangeTrigger> triggers, @Nullable String purpose, @Nullable PersonId executedBy, Instant changeDate) {
        this(change.getId(), change.getItemId(), change.getVersion(), triggers, executedBy, changeDate);
    }

    public ChangeWithTriggers(DocumentVersionId changeId, ItemId itemId, int version, ImmutableSet<? extends ChangeTrigger> triggers, @Nullable PersonId executedBy, Instant changeDate) {
        this._changeId = changeId;
        this._itemId = itemId;
        this._version = version;
        this._triggers = triggers;
        this._executedBy = executedBy;
        this._changeDate = changeDate;
    }

    public DocumentVersionId getId() {
        return this._changeId;
    }

    public ItemId getItemId() {
        return this._itemId;
    }

    public int getVersion() {
        return this._version;
    }

    public ImmutableSet<? extends ChangeTrigger> getChangeTriggers() {
        return this._triggers;
    }

    public Optional<PersonId> getExecutedBy() {
        return Optional.ofNullable(this._executedBy);
    }

    public Instant getChangeDate() {
        return this._changeDate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("changeId", (Object)this._changeId).add("itemId", (Object)this._itemId).add("version", this._version).add("triggers", (Object)this._triggers).add("executedBy", (Object)this._executedBy).toString();
    }
}

