/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.drive.batch.file;

import de.justsoftware.drive.business.file.TempFileService;
import java.time.Clock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class TempFileCleaner {
    private final int _maxAge;
    private final TempFileService _tempFileService;
    private final Clock _clock;

    @Autowired
    public TempFileCleaner(@Value(value="${just.drive.tmp.cleaner.maxAge:86400}") int maxAge, TempFileService tempFileService, Clock clock) {
        this._maxAge = maxAge;
        this._tempFileService = tempFileService;
        this._clock = clock;
    }

    @Scheduled(cron="${just.drive.tmp.cleaner.cron:0 0 2 * * *}")
    public void deleteTempFiles() {
        this._tempFileService.deleteTempfilesOlderThan(this._clock.instant().minusSeconds(this._maxAge));
    }
}

