/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.virusscan;

import de.justsoftware.justdocumentz.api.VirusScanStatus;
import de.justsoftware.justdocumentz.common.FileCacheService;
import de.justsoftware.justdocumentz.common.StorageServerFileNotFoundException;
import de.justsoftware.justdocumentz.events.VirusScanStatusChangeEvent;
import de.justsoftware.justdocumentz.virusscan.VirusScanJobRunner;
import de.justsoftware.justdocumentz.virusscan.VirusScanResult;
import de.justsoftware.justdocumentz.virusscan.VirusScanService;
import java.nio.file.Path;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0017\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0012J\u0018\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0012H\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lde/justsoftware/justdocumentz/virusscan/VirusScanJobRunner;", "", "fileCacheService", "Lde/justsoftware/justdocumentz/common/FileCacheService;", "virusScanService", "Lde/justsoftware/justdocumentz/virusscan/VirusScanService;", "eventPublisher", "Lorg/springframework/context/ApplicationEventPublisher;", "(Lde/justsoftware/justdocumentz/common/FileCacheService;Lde/justsoftware/justdocumentz/virusscan/VirusScanService;Lorg/springframework/context/ApplicationEventPublisher;)V", "getEventPublisher", "()Lorg/springframework/context/ApplicationEventPublisher;", "getFileCacheService", "()Lde/justsoftware/justdocumentz/common/FileCacheService;", "getVirusScanService", "()Lde/justsoftware/justdocumentz/virusscan/VirusScanService;", "publishVirusScanChange", "", "storageId", "", "status", "Lde/justsoftware/justdocumentz/api/VirusScanStatus;", "virusSignatureCode", "scanDate", "Ljava/time/Instant;", "scanForVirus", "remoteUrl", "Companion", "just-documentz"})
public class VirusScanJobRunner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FileCacheService fileCacheService;
    @NotNull
    private final VirusScanService virusScanService;
    @NotNull
    private final ApplicationEventPublisher eventPublisher;
    private static final Logger logger = LoggerFactory.getLogger(VirusScanJobRunner.class);

    public VirusScanJobRunner(@NotNull FileCacheService fileCacheService, @NotNull VirusScanService virusScanService, @NotNull ApplicationEventPublisher eventPublisher) {
        Intrinsics.checkNotNullParameter((Object)fileCacheService, (String)"fileCacheService");
        Intrinsics.checkNotNullParameter((Object)virusScanService, (String)"virusScanService");
        Intrinsics.checkNotNullParameter((Object)eventPublisher, (String)"eventPublisher");
        this.fileCacheService = fileCacheService;
        this.virusScanService = virusScanService;
        this.eventPublisher = eventPublisher;
    }

    @NotNull
    public FileCacheService getFileCacheService() {
        return this.fileCacheService;
    }

    @NotNull
    public VirusScanService getVirusScanService() {
        return this.virusScanService;
    }

    @NotNull
    public ApplicationEventPublisher getEventPublisher() {
        return this.eventPublisher;
    }

    public void scanForVirus(@NotNull String storageId, @NotNull String remoteUrl) {
        Object object;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)storageId, (String)"storageId");
        Intrinsics.checkNotNullParameter((Object)remoteUrl, (String)"remoteUrl");
        logger.info("Starting virus scan for task: " + storageId);
        this.publishVirusScanChange(storageId, VirusScanStatus.PROCESSING, null, null);
        Object object3 = this.getFileCacheService().downloadToFileCache-0E7RQCE(storageId, remoteUrl, true);
        if (Result.isSuccess-impl((Object)object3)) {
            Object object4;
            object2 = object3;
            try {
                object4 = object2;
                Path downloadedFile = (Path)object4;
                boolean bl = false;
                VirusScanResult virusScanResult = this.getVirusScanService().findVirus(downloadedFile);
                boolean virusDetected = virusScanResult.component1();
                String virusSignatureCode = virusScanResult.component2();
                if (virusDetected) {
                    logger.warn("Virus detected for task: " + storageId + ". virusSignatureCode: " + virusSignatureCode);
                    this.publishVirusScanChange(storageId, VirusScanStatus.INFECTED, virusSignatureCode, Instant.now());
                } else {
                    logger.info("No virus detected for task: " + storageId);
                    this.publishVirusScanChange(storageId, VirusScanStatus.CLEAN, null, Instant.now());
                }
                object4 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable downloadedFile) {
                object4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)downloadedFile));
            }
            object = object4;
        } else {
            object = Result.constructor-impl((Object)object3);
        }
        object3 = object;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object3);
        if (throwable != null) {
            Object it = object2 = throwable;
            boolean bl = false;
            if (it instanceof StorageServerFileNotFoundException) {
                logger.warn("File does not exist on storage server: " + storageId);
                this.publishVirusScanChange(storageId, VirusScanStatus.MISSING, null, Instant.now());
            } else {
                logger.error("Error during virus scan for task: " + storageId, (Throwable)it);
                this.publishVirusScanChange(storageId, VirusScanStatus.ERROR, null, Instant.now());
            }
        }
        Object it = object3;
        boolean bl = false;
        this.getFileCacheService().removeFromFileCache(storageId);
    }

    private void publishVirusScanChange(String storageId, VirusScanStatus status, String virusSignatureCode, Instant scanDate) {
        this.getEventPublisher().publishEvent((Object)new VirusScanStatusChangeEvent((Object)this, storageId, status, virusSignatureCode, scanDate));
    }
}

