/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.scheduled;

import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.util.FileUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lde/justsoftware/justdocumentz/scheduled/TempFileCleanupTask;", "", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;)V", "logger", "Lorg/slf4j/Logger;", "getLogger", "()Lorg/slf4j/Logger;", "cleanupOldTempFiles", "", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nTempFileCleanupTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TempFileCleanupTask.kt\nde/justsoftware/justdocumentz/scheduled/TempFileCleanupTask\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n*L\n1#1,41:1\n9#2:42\n*S KotlinDebug\n*F\n+ 1 TempFileCleanupTask.kt\nde/justsoftware/justdocumentz/scheduled/TempFileCleanupTask\n*L\n15#1:42\n*E\n"})
public class TempFileCleanupTask {
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final Logger logger;

    public TempFileCleanupTask(@NotNull JudoConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
        TempFileCleanupTask $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(TempFileCleanupTask.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
    }

    @NotNull
    public Logger getLogger() {
        return this.logger;
    }

    @Scheduled(fixedRateString="${judo.scheduled.tempFileCleanup.interval}")
    public void cleanupOldTempFiles() {
        block3: {
            Object object;
            this.getLogger().info("Starting temporary file cleanup...");
            Object object2 = this;
            try {
                TempFileCleanupTask $this$cleanupOldTempFiles_u24lambda_u240 = object2;
                boolean bl = false;
                if (!Files.exists($this$cleanupOldTempFiles_u24lambda_u240.config.getTempDirPath(), new LinkOption[0])) {
                    $this$cleanupOldTempFiles_u24lambda_u240.getLogger().info("Configured temp file dir does not exist");
                    return;
                }
                Duration maxFileAge = $this$cleanupOldTempFiles_u24lambda_u240.config.getScheduled().getTempFileCleanup().getMaxAge();
                Instant cutoffTime = Instant.now().minusMillis(maxFileAge.toMillis());
                Function2 isOlderThan2 = (Function2)new /* Unavailable Anonymous Inner Class!! */;
                long deletedCount = FileUtils.INSTANCE.deleteWhere($this$cleanupOldTempFiles_u24lambda_u240.config.getTempDirPath(), isOlderThan2);
                $this$cleanupOldTempFiles_u24lambda_u240.getLogger().info("File cleanup completed. Deleted " + deletedCount + " files older than " + maxFileAge);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object e = object = throwable;
            boolean bl = false;
            this.getLogger().error("File cleanup failed with error", (Throwable)e);
        }
    }
}

