/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions.video;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.justdocumentz.common.ContainerImageService;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.config.PodmanConfig;
import de.justsoftware.justdocumentz.conversions.ConversionService;
import de.justsoftware.justdocumentz.conversions.video.FfProbeOutput;
import de.justsoftware.justdocumentz.conversions.video.FfProbeVideoStream;
import de.justsoftware.justdocumentz.conversions.video.VideoConversionException;
import de.justsoftware.justdocumentz.conversions.video.VideoConversionResult;
import de.justsoftware.justdocumentz.conversions.video.VideoConversionService;
import de.justsoftware.justdocumentz.monitoring.ConversionAvailabilityTracker;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.MimeType;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 * Exception performing whole class analysis ignored.
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0017\u0018\u0000 :2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001:B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020!H\u0016J\"\u0010%\u001a\u00020!2\u0006\u0010 \u001a\u00020!2\u0006\u0010$\u001a\u00020!2\b\u0010&\u001a\u0004\u0018\u00010'H\u0012J \u0010(\u001a\u00020!2\u0006\u0010)\u001a\u00020!2\u0006\u0010$\u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0012J\u0010\u0010*\u001a\u00020\u00172\u0006\u0010)\u001a\u00020!H\u0012J\b\u0010+\u001a\u00020\u001eH\u0012J\u0010\u0010,\u001a\u00020-2\u0006\u0010\"\u001a\u00020#H\u0016J\u001b\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0017\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b1\u00102J\u0012\u00103\u001a\u0004\u0018\u00010'2\u0006\u00104\u001a\u00020\u0017H\u0012J+\u00105\u001a\u000200*\b\u0012\u0004\u0012\u00020\u0017062\u0012\u00107\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001708\"\u00020\u0017H\u0012\u00a2\u0006\u0002\u00109R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0017X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u001d\u001a\u00020\u001eX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006;"}, d2={"Lde/justsoftware/justdocumentz/conversions/video/VideoConversionService;", "Lde/justsoftware/justdocumentz/conversions/ConversionService;", "Lde/justsoftware/justdocumentz/conversions/video/VideoConversionResult;", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "containerImageService", "Lde/justsoftware/justdocumentz/common/ContainerImageService;", "environment", "Lorg/springframework/core/env/Environment;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "availabilityTracker", "Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/common/ContainerImageService;Lorg/springframework/core/env/Environment;Lcom/fasterxml/jackson/databind/ObjectMapper;Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;)V", "getAvailabilityTracker", "()Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "getContainerImageService", "()Lde/justsoftware/justdocumentz/common/ContainerImageService;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "ffmpegImage", "", "justContainerVersion", "logger", "Lorg/slf4j/Logger;", "getObjectMapper", "()Lcom/fasterxml/jackson/databind/ObjectMapper;", "videoPodmanConfig", "Lde/justsoftware/justdocumentz/config/PodmanConfig;", "convert", "inputFile", "Ljava/nio/file/Path;", "mimeType", "Lorg/springframework/util/MimeType;", "tempDir", "convertVideo", "info", "Lde/justsoftware/justdocumentz/conversions/video/FfProbeVideoStream;", "createCoverImage", "videoPath", "ffProbe", "initPodmanConfig", "isSupported", "", "onApplicationStartedEvent", "Lkotlin/Result;", "", "onApplicationStartedEvent-d1pmJ48", "()Ljava/lang/Object;", "parseVideoInformation", "ffProbeOutputString", "addArgs", "", "args", "", "(Ljava/util/List;[Ljava/lang/String;)V", "Companion", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nVideoConversionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VideoConversionService.kt\nde/justsoftware/justdocumentz/conversions/video/VideoConversionService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,299:1\n9#2:300\n1#3:301\n288#4,2:302\n*S KotlinDebug\n*F\n+ 1 VideoConversionService.kt\nde/justsoftware/justdocumentz/conversions/video/VideoConversionService\n*L\n36#1:300\n149#1:302,2\n*E\n"})
public class VideoConversionService
implements ConversionService<VideoConversionResult> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final ContainerImageService containerImageService;
    @NotNull
    private final Environment environment;
    @NotNull
    private final ObjectMapper objectMapper;
    @NotNull
    private final ConversionAvailabilityTracker availabilityTracker;
    @NotNull
    private final Logger logger;
    @Nullable
    private final String justContainerVersion;
    @NotNull
    private final String ffmpegImage;
    @NotNull
    private final PodmanConfig videoPodmanConfig;
    @NotNull
    private static final List<String> containerUserArgs;
    @NotNull
    private static final String containerInputDir = "/home/justsoftware/input";
    @NotNull
    private static final String containerOutputDir = "/home/justsoftware/output";

    public VideoConversionService(@NotNull JudoConfig config, @NotNull ContainerImageService containerImageService, @NotNull Environment environment, @NotNull ObjectMapper objectMapper, @NotNull ConversionAvailabilityTracker availabilityTracker) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)containerImageService, (String)"containerImageService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)objectMapper, (String)"objectMapper");
        Intrinsics.checkNotNullParameter((Object)availabilityTracker, (String)"availabilityTracker");
        this.config = config;
        this.containerImageService = containerImageService;
        this.environment = environment;
        this.objectMapper = objectMapper;
        this.availabilityTracker = availabilityTracker;
        VideoConversionService $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(VideoConversionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.justContainerVersion = this.getEnvironment().getProperty("just.containerVersion");
        this.ffmpegImage = "docker.io/justsocial/just-ffmpeg:" + this.justContainerVersion;
        this.videoPodmanConfig = this.initPodmanConfig();
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public ContainerImageService getContainerImageService() {
        return this.containerImageService;
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @NotNull
    public ConversionAvailabilityTracker getAvailabilityTracker() {
        return this.availabilityTracker;
    }

    @EventListener(value={ApplicationStartedEvent.class})
    @NotNull
    public Object onApplicationStartedEvent-d1pmJ48() {
        Object object;
        block3: {
            Object object2;
            object = this;
            try {
                VideoConversionService $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241 = object;
                boolean bl = false;
                $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.logger.info("Initializing " + $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getClass().getSimpleName() + "...");
                if (!$this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getContainerImageService().isPodmanAvailable()) {
                    boolean $i$a$-check-VideoConversionService$onApplicationStartedEvent$1$22 = false;
                    String $i$a$-check-VideoConversionService$onApplicationStartedEvent$1$22 = "Podman is not available on this system. Please install Podman to use PDF conversion.";
                    throw new IllegalStateException($i$a$-check-VideoConversionService$onApplicationStartedEvent$1$22.toString());
                }
                $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getContainerImageService().ensureImageAvailable($this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.ffmpegImage);
                $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u241.getAvailabilityTracker().setVideoAvailable(true);
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block3;
            Object e = object2 = throwable;
            boolean bl = false;
            this.getAvailabilityTracker().setVideoAvailable(false);
            this.logger.error("Failed to initialize video conversion", (Throwable)e);
        }
        return object;
    }

    public boolean isSupported(@NotNull MimeType mimeType) {
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        return Intrinsics.areEqual((Object)mimeType.getType(), (Object)"video");
    }

    @NotNull
    public VideoConversionResult convert(@NotNull Path inputFile, @NotNull MimeType mimeType, @NotNull Path tempDir) {
        Path path;
        Path path2;
        Object it;
        Object $this$convert_u24lambda_u2411;
        Throwable it2;
        Object $this$convert_u24lambda_u248;
        Object it3;
        Object $this$convert_u24lambda_u245;
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        VideoConversionService videoConversionService = this;
        try {
            $this$convert_u24lambda_u245 = videoConversionService;
            boolean bl = false;
            $this$convert_u24lambda_u245 = Result.constructor-impl((Object)$this$convert_u24lambda_u245.ffProbe(inputFile));
        }
        catch (Throwable bl) {
            $this$convert_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        videoConversionService = $this$convert_u24lambda_u245;
        Throwable throwable = Result.exceptionOrNull-impl((Object)videoConversionService);
        if (throwable != null) {
            it3 = throwable;
            boolean bl = false;
            VideoConversionService.convert$fail$default((Path)inputFile, (String)"Error while executing ffprobe", (Throwable)it3, null, (int)8, null);
            throw new KotlinNothingValueException();
        }
        it3 = (String)videoConversionService;
        boolean bl = false;
        this.logger.debug("ffprobeOutput: {}", it3);
        String ffProbeOutput = (String)videoConversionService;
        it3 = this;
        try {
            $this$convert_u24lambda_u248 = (VideoConversionService)it3;
            boolean bl2 = false;
            $this$convert_u24lambda_u248 = Result.constructor-impl((Object)$this$convert_u24lambda_u248.parseVideoInformation(ffProbeOutput));
        }
        catch (Throwable bl2) {
            $this$convert_u24lambda_u248 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        it3 = $this$convert_u24lambda_u248;
        Throwable throwable2 = Result.exceptionOrNull-impl((Object)it3);
        if (throwable2 != null) {
            it2 = throwable2;
            boolean bl3 = false;
            VideoConversionService.convert$fail((Path)inputFile, (String)"Error while parsing ffprobe output", (Throwable)it2, (String)ffProbeOutput);
            throw new KotlinNothingValueException();
        }
        it2 = (FfProbeVideoStream)it3;
        boolean bl4 = false;
        this.logger.debug("videoInformation: {}", (Object)it2);
        FfProbeVideoStream videoInformation = (FfProbeVideoStream)it3;
        it2 = this;
        try {
            $this$convert_u24lambda_u2411 = (VideoConversionService)it2;
            boolean bl5 = false;
            $this$convert_u24lambda_u2411 = Result.constructor-impl((Object)$this$convert_u24lambda_u2411.convertVideo(inputFile, tempDir, videoInformation));
        }
        catch (Throwable bl5) {
            $this$convert_u24lambda_u2411 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl5));
        }
        it2 = $this$convert_u24lambda_u2411;
        Throwable throwable3 = Result.exceptionOrNull-impl((Object)it2);
        if (throwable3 != null) {
            it = throwable3;
            boolean bl6 = false;
            VideoConversionService.convert$fail((Path)inputFile, (String)"Error while converting video", (Throwable)it, (String)ffProbeOutput);
            throw new KotlinNothingValueException();
        }
        it = (Path)((Object)it2);
        boolean bl7 = false;
        this.logger.debug("convertedVideo: {}", it);
        Path convertedVideo = (Path)((Object)it2);
        FfProbeVideoStream ffProbeVideoStream = videoInformation;
        if (ffProbeVideoStream != null) {
            Object object;
            Object object2;
            FfProbeVideoStream info = ffProbeVideoStream;
            boolean bl8 = false;
            Object object3 = this;
            try {
                VideoConversionService $this$convert_u24lambda_u2417_u24lambda_u2414 = object3;
                boolean bl9 = false;
                object2 = Result.constructor-impl((Object)$this$convert_u24lambda_u2417_u24lambda_u2414.createCoverImage(inputFile, tempDir, info));
            }
            catch (Throwable bl9) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl9));
            }
            object3 = object2;
            object2 = Result.exceptionOrNull-impl((Object)object3);
            if (object2 == null) {
                object = object3;
            } else {
                Object it4;
                Object bl9 = object3;
                try {
                    it4 = object2;
                    boolean bl10 = false;
                    it4 = Result.constructor-impl((Object)this.createCoverImage(convertedVideo, tempDir, info));
                }
                catch (Throwable throwable4) {
                    it4 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable4));
                }
                object = it4;
            }
            object3 = object;
            Throwable throwable5 = Result.exceptionOrNull-impl((Object)object3);
            if (throwable5 != null) {
                Object throwable6 = object2 = throwable5;
                boolean bl11 = false;
                this.logger.warn(VideoConversionService.convert$buildErrorMessage((Path)inputFile, (String)"Failed to create cover image", (String)ffProbeOutput), (Throwable)throwable6);
            }
            path2 = (Path)(Result.isFailure-impl((Object)object3) ? null : object3);
        } else {
            path2 = null;
        }
        Path it5 = path = path2;
        boolean bl12 = false;
        this.logger.debug("coverImage: {}", it5);
        Path coverImage = path;
        return new VideoConversionResult(convertedVideo, coverImage);
    }

    private String ffProbe(Path videoPath) {
        List list;
        List $this$ffProbe_u24lambda_u2419 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$ffProbe_u24lambda_u2419.addAll(containerUserArgs);
        String[] stringArray = new String[]{"-v", videoPath.getParent() + ":/home/justsoftware/input:ro", "--entrypoint", "ffprobe", this.ffmpegImage, "-hide_banner", "-of", "json", "-loglevel", "info", "-show_streams", "-show_format", "/home/justsoftware/input/" + videoPath.getFileName()};
        this.addArgs($this$ffProbe_u24lambda_u2419, stringArray);
        return CommandLineUtilsKt.podmanRun-BZiP2OM$default((List)CollectionsKt.build((List)list), (PodmanConfig)this.videoPodmanConfig, (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), (boolean)false, null, (int)16, null).getOutput();
    }

    /*
     * WARNING - void declaration
     */
    private FfProbeVideoStream parseVideoInformation(String ffProbeOutputString) {
        FfProbeVideoStream ffProbeVideoStream;
        Object v1;
        block3: {
            void $this$firstOrNull$iv;
            FfProbeOutput ffProbeOutput = (FfProbeOutput)this.getObjectMapper().readValue(ffProbeOutputString, FfProbeOutput.class);
            Iterable iterable = ffProbeOutput.getStreams();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                JsonNode it = (JsonNode)element$iv;
                boolean bl = false;
                JsonNode jsonNode = it.get("codec_type");
                if (!Intrinsics.areEqual((Object)(jsonNode != null ? jsonNode.asText() : null), (Object)"video")) continue;
                v1 = element$iv;
                break block3;
            }
            v1 = null;
        }
        JsonNode jsonNode = v1;
        if (jsonNode != null) {
            JsonNode videoStreamNode = jsonNode;
            boolean bl = false;
            ffProbeVideoStream = (FfProbeVideoStream)this.getObjectMapper().treeToValue((TreeNode)videoStreamNode, FfProbeVideoStream.class);
        } else {
            ffProbeVideoStream = null;
        }
        return ffProbeVideoStream;
    }

    private Path createCoverImage(Path videoPath, Path tempDir, FfProbeVideoStream info) {
        List list;
        Path inputDir = videoPath.getParent();
        String outputFileName = "cover-image.png";
        List $this$createCoverImage_u24lambda_u2422 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        $this$createCoverImage_u24lambda_u2422.addAll(containerUserArgs);
        String[] stringArray = new String[]{"-v", inputDir + ":/home/justsoftware/input:ro", "-v", tempDir + ":/home/justsoftware/output", "--entrypoint", "ffmpeg", this.ffmpegImage, "-y", "-ss", String.valueOf(MathKt.roundToInt((double)(info.getDuration() / (double)2))), "-i", "/home/justsoftware/input/" + videoPath.getFileName(), "-frames:v", "1", "/home/justsoftware/output/" + outputFileName};
        this.addArgs($this$createCoverImage_u24lambda_u2422, stringArray);
        CommandLineUtilsKt.podmanRun-BZiP2OM$default((List)CollectionsKt.build((List)list), (PodmanConfig)this.videoPodmanConfig, (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), (boolean)false, null, (int)24, null);
        Path coverImagePath = tempDir.resolve(outputFileName);
        if (!Files.exists(coverImagePath, new LinkOption[0])) {
            boolean bl2 = false;
            String string = "Cover image generation appeared to succeed but output file not found: " + coverImagePath;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)coverImagePath);
        return coverImagePath;
    }

    private Path convertVideo(Path inputFile, Path tempDir, FfProbeVideoStream info) {
        String targetPixelFormat = "yuv420p";
        String targetVideoCodec = "h264";
        Path inputDir = inputFile.getParent();
        String outputFileName = "output.mp4";
        Object object = CollectionsKt.createListBuilder();
        List $this$convertVideo_u24lambda_u2424 = object;
        boolean bl = false;
        $this$convertVideo_u24lambda_u2424.addAll(containerUserArgs);
        String[] stringArray = new String[]{"-v", inputDir + ":/home/justsoftware/input:ro"};
        this.addArgs($this$convertVideo_u24lambda_u2424, stringArray);
        stringArray = new String[]{"-v", tempDir + ":/home/justsoftware/output"};
        this.addArgs($this$convertVideo_u24lambda_u2424, stringArray);
        stringArray = new String[]{"--entrypoint", "ffmpeg"};
        this.addArgs($this$convertVideo_u24lambda_u2424, stringArray);
        $this$convertVideo_u24lambda_u2424.add(this.ffmpegImage);
        stringArray = new String[]{"-i", "/home/justsoftware/input/" + inputFile.getFileName()};
        this.addArgs($this$convertVideo_u24lambda_u2424, stringArray);
        if (info == null) {
            stringArray = new String[]{"-c:v", "copy"};
            this.addArgs($this$convertVideo_u24lambda_u2424, stringArray);
        } else {
            String[] stringArray2;
            String videoCodec;
            boolean isTooLarge = info.getWidth() > info.getHeight() ? info.getHeight() > 720 : info.getWidth() > 1280;
            boolean dimensionsDivisibleByTwo = info.getWidth() % 2 == 0 && info.getHeight() % 2 == 0;
            boolean needsScaling = isTooLarge || !dimensionsDivisibleByTwo;
            boolean needsReEncoding = !Intrinsics.areEqual((Object)info.getCodecName(), (Object)targetVideoCodec) || !Intrinsics.areEqual((Object)info.getPixelFormat(), (Object)targetPixelFormat) || needsScaling;
            String string = videoCodec = needsReEncoding ? "libx264" : "copy";
            if (needsReEncoding) {
                stringArray2 = new String[]{"-preset", "superfast"};
                this.addArgs($this$convertVideo_u24lambda_u2424, stringArray2);
                stringArray2 = new String[]{"-crf", "27"};
                this.addArgs($this$convertVideo_u24lambda_u2424, stringArray2);
                stringArray2 = new String[]{"-pix_fmt", targetPixelFormat};
                this.addArgs($this$convertVideo_u24lambda_u2424, stringArray2);
            }
            if (needsScaling) {
                stringArray2 = new String[]{"-vf", info.getWidth() > info.getHeight() ? "scale=-2:720" : "scale=1280:-2"};
                this.addArgs($this$convertVideo_u24lambda_u2424, stringArray2);
            }
            stringArray2 = new String[]{"-c:v", videoCodec};
            this.addArgs($this$convertVideo_u24lambda_u2424, stringArray2);
        }
        String[] stringArray3 = new String[]{"-c:a", "aac"};
        this.addArgs($this$convertVideo_u24lambda_u2424, stringArray3);
        stringArray3 = new String[]{"-b:a", "128k"};
        this.addArgs($this$convertVideo_u24lambda_u2424, stringArray3);
        stringArray3 = new String[]{"-movflags", "+faststart"};
        this.addArgs($this$convertVideo_u24lambda_u2424, stringArray3);
        $this$convertVideo_u24lambda_u2424.add("/home/justsoftware/output/" + outputFileName);
        List command = CollectionsKt.build((List)object);
        object = this.getConfig().getConverter().getMaxVideoConversionDuration();
        CommandLineUtilsKt.podmanRun-BZiP2OM$default((List)command, (PodmanConfig)this.videoPodmanConfig, (Duration)Duration.box-impl((long)Duration.plus-LRDsOJo((long)DurationKt.toDuration((long)((java.time.Duration)object).getSeconds(), (DurationUnit)DurationUnit.SECONDS), (long)DurationKt.toDuration((int)((java.time.Duration)object).getNano(), (DurationUnit)DurationUnit.NANOSECONDS))), (boolean)false, null, (int)24, null);
        Path convertedVideoPath = tempDir.resolve(outputFileName);
        if (!Files.exists(convertedVideoPath, new LinkOption[0])) {
            boolean bl2 = false;
            String string = "Video conversion appeared to succeed but output file not found: " + convertedVideoPath;
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNull((Object)convertedVideoPath);
        return convertedVideoPath;
    }

    private void addArgs(List<String> $this$addArgs, String ... args) {
        CollectionsKt.addAll((Collection)$this$addArgs, (Object[])args);
    }

    private PodmanConfig initPodmanConfig() {
        int availableCpus = Runtime.getRuntime().availableProcessors();
        int cpusForVideoConversion = RangesKt.coerceAtLeast((int)this.getConfig().getPodman().getVideo().getCpus(), (int)(availableCpus / 2));
        PodmanConfig videoConfig = PodmanConfig.copy$default((PodmanConfig)this.getConfig().getPodman().getVideo(), null, (int)RangesKt.coerceAtLeast((int)2, (int)cpusForVideoConversion), null, null, (int)13, null);
        this.logger.info("Video config " + videoConfig);
        return videoConfig;
    }

    private static final String convert$buildErrorMessage(Path $inputFile, String baseMessage, String ffprobeOutput) {
        StringBuilder stringBuilder;
        StringBuilder $this$convert_u24buildErrorMessage_u24lambda_u244 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$convert_u24buildErrorMessage_u24lambda_u244.append(baseMessage + " for: " + $inputFile);
        String string = ffprobeOutput;
        if (string != null) {
            String it = string;
            boolean bl2 = false;
            $this$convert_u24buildErrorMessage_u24lambda_u244.append("\nffprobe output was: \n" + ffprobeOutput);
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private static final Void convert$fail(Path $inputFile, String message, Throwable cause, String ffprobeOutput) {
        throw new VideoConversionException(VideoConversionService.convert$buildErrorMessage((Path)$inputFile, (String)message, (String)ffprobeOutput), cause);
    }

    static /* synthetic */ Void convert$fail$default(Path path, String string, Throwable throwable, String string2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: convert$fail");
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        return VideoConversionService.convert$fail((Path)path, (String)string, (Throwable)throwable, (String)string2);
    }

    static {
        Object[] objectArray = new String[]{"--user", "justsoftware", "--userns", "keep-id:uid=900,gid=900"};
        containerUserArgs = CollectionsKt.listOf((Object[])objectArray);
    }
}

