/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.conversions.document;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.justsoftware.justdocumentz.common.ContainerImageService;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.config.PodmanConfig;
import de.justsoftware.justdocumentz.conversions.ConversionService;
import de.justsoftware.justdocumentz.conversions.UnsupportedConversionException;
import de.justsoftware.justdocumentz.conversions.document.DocumentConversionService;
import de.justsoftware.justdocumentz.conversions.document.Pdf2IFrameConversionService;
import de.justsoftware.justdocumentz.monitoring.ConversionAvailabilityTracker;
import de.justsoftware.justdocumentz.util.CommandLineUtilsKt;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.Duration;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.env.Environment;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.MimeType;
import org.springframework.util.MimeTypeUtils;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0017\u0018\u0000 .2\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001:\u0001.B-\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ&\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010#\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u0003H\u0016J\u0018\u0010%\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0012J\u0010\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020\u0010H\u0016J\u001b\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)H\u0017\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\b+\u0010,J\u0018\u0010-\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003H\u0012R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\u0002X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u0082\u0002\u000b\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006/"}, d2={"Lde/justsoftware/justdocumentz/conversions/document/DocumentConversionService;", "Lde/justsoftware/justdocumentz/conversions/ConversionService;", "", "Ljava/nio/file/Path;", "config", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "containerImageService", "Lde/justsoftware/justdocumentz/common/ContainerImageService;", "pdf2IFrameConversionService", "Lde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService;", "environment", "Lorg/springframework/core/env/Environment;", "availabilityTracker", "Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/common/ContainerImageService;Lde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService;Lorg/springframework/core/env/Environment;Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;)V", "allowedMimeTypes", "Lorg/springframework/util/MimeType;", "getAvailabilityTracker", "()Lde/justsoftware/justdocumentz/monitoring/ConversionAvailabilityTracker;", "getConfig", "()Lde/justsoftware/justdocumentz/config/JudoConfig;", "getContainerImageService", "()Lde/justsoftware/justdocumentz/common/ContainerImageService;", "getEnvironment", "()Lorg/springframework/core/env/Environment;", "justContainerVersion", "", "justPdfToPpmImage", "libreOfficeImage", "logger", "Lorg/slf4j/Logger;", "getPdf2IFrameConversionService", "()Lde/justsoftware/justdocumentz/conversions/document/Pdf2IFrameConversionService;", "convert", "inputFile", "mimeType", "tempDir", "convertToPdf", "isSupported", "", "onApplicationStartedEvent", "Lkotlin/Result;", "", "onApplicationStartedEvent-d1pmJ48", "()Ljava/lang/Object;", "scalePdf", "Companion", "just-documentz"})
@SourceDebugExtension(value={"SMAP\nDocumentConversionService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocumentConversionService.kt\nde/justsoftware/justdocumentz/conversions/document/DocumentConversionService\n+ 2 LoggerExtensions.kt\nde/justsoftware/justdocumentz/util/LoggerExtensionsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,395:1\n9#2:396\n9#2:408\n1603#3,9:397\n1855#3:406\n1856#3:410\n1612#3:411\n1747#3,3:412\n1549#3:415\n1620#3,3:416\n1#4:407\n1#4:409\n*S KotlinDebug\n*F\n+ 1 DocumentConversionService.kt\nde/justsoftware/justdocumentz/conversions/document/DocumentConversionService\n*L\n47#1:396\n54#1:408\n52#1:397,9\n52#1:406\n52#1:410\n52#1:411\n80#1:412,3\n100#1:415\n100#1:416,3\n52#1:409\n*E\n"})
public class DocumentConversionService
implements ConversionService<List<? extends Path>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JudoConfig config;
    @NotNull
    private final ContainerImageService containerImageService;
    @NotNull
    private final Pdf2IFrameConversionService pdf2IFrameConversionService;
    @NotNull
    private final Environment environment;
    @NotNull
    private final ConversionAvailabilityTracker availabilityTracker;
    @NotNull
    private final Logger logger;
    @Nullable
    private final String justContainerVersion;
    @NotNull
    private final String libreOfficeImage;
    @NotNull
    private final String justPdfToPpmImage;
    @NotNull
    private final List<MimeType> allowedMimeTypes;
    @NotNull
    private static final String pdfExportConfiguration;

    /*
     * WARNING - void declaration
     */
    public DocumentConversionService(@NotNull JudoConfig config, @NotNull ContainerImageService containerImageService, @NotNull Pdf2IFrameConversionService pdf2IFrameConversionService, @NotNull Environment environment, @NotNull ConversionAvailabilityTracker availabilityTracker) {
        void it;
        List list;
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)containerImageService, (String)"containerImageService");
        Intrinsics.checkNotNullParameter((Object)pdf2IFrameConversionService, (String)"pdf2IFrameConversionService");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        Intrinsics.checkNotNullParameter((Object)availabilityTracker, (String)"availabilityTracker");
        this.config = config;
        this.containerImageService = containerImageService;
        this.pdf2IFrameConversionService = pdf2IFrameConversionService;
        this.environment = environment;
        this.availabilityTracker = availabilityTracker;
        Object $this$logger$iv = this;
        boolean $i$f$logger = false;
        Logger logger = LoggerFactory.getLogger(DocumentConversionService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        this.logger = logger;
        this.justContainerVersion = this.getEnvironment().getProperty("just.containerVersion");
        this.libreOfficeImage = "docker.io/justsocial/just-pdf-converter:" + this.justContainerVersion;
        this.justPdfToPpmImage = "docker.io/justsocial/just-pdftoppm:" + this.justContainerVersion;
        $this$logger$iv = this.getConfig().getConverter().getAllowedMimeTypes();
        DocumentConversionService documentConversionService = this;
        boolean $i$f$mapNotNull22 = false;
        void var8_10 = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            MimeType it$iv$iv;
            Object object;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String mimeTypeString = (String)element$iv$iv;
            boolean bl2 = false;
            Object object2 = this;
            try {
                DocumentConversionService $this$allowedMimeTypes_u24lambda_u242_u24lambda_u240 = object2;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)MimeTypeUtils.parseMimeType((String)mimeTypeString));
            }
            catch (Throwable bl3) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable != null) {
                Object t = object = throwable;
                boolean bl4 = false;
                DocumentConversionService $this$logger$iv2 = this;
                boolean $i$f$logger2 = false;
                Logger logger2 = LoggerFactory.getLogger(DocumentConversionService.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getLogger(...)");
                logger2.warn("Failed to parse mime type " + mimeTypeString + ". message: " + ((Throwable)t).getMessage());
            }
            if ((MimeType)(Result.isFailure-impl((Object)object2) ? null : object2) == null) continue;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List $i$f$mapNotNull22 = list = (List)destination$iv$iv;
        boolean bl = false;
        this.logger.info(it.size() + " allowed mimeTypes");
        documentConversionService.allowedMimeTypes = list;
    }

    @NotNull
    public JudoConfig getConfig() {
        return this.config;
    }

    @NotNull
    public ContainerImageService getContainerImageService() {
        return this.containerImageService;
    }

    @NotNull
    public Pdf2IFrameConversionService getPdf2IFrameConversionService() {
        return this.pdf2IFrameConversionService;
    }

    @NotNull
    public Environment getEnvironment() {
        return this.environment;
    }

    @NotNull
    public ConversionAvailabilityTracker getAvailabilityTracker() {
        return this.availabilityTracker;
    }

    @EventListener(value={ApplicationStartedEvent.class})
    @NotNull
    public Object onApplicationStartedEvent-d1pmJ48() {
        Object object;
        block3: {
            Object object2;
            object = this;
            try {
                DocumentConversionService $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u245 = object;
                boolean bl = false;
                $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u245.logger.info("Initializing " + $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u245.getClass().getSimpleName() + "...");
                if (!$this$onApplicationStartedEvent_d1pmJ48_u24lambda_u245.getContainerImageService().isPodmanAvailable()) {
                    boolean $i$a$-check-DocumentConversionService$onApplicationStartedEvent$1$22 = false;
                    String $i$a$-check-DocumentConversionService$onApplicationStartedEvent$1$22 = "Podman is not available on this system. Please install Podman to use PDF conversion.";
                    throw new IllegalStateException($i$a$-check-DocumentConversionService$onApplicationStartedEvent$1$22.toString());
                }
                $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u245.getContainerImageService().ensureImageAvailable($this$onApplicationStartedEvent_d1pmJ48_u24lambda_u245.libreOfficeImage);
                $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u245.getContainerImageService().ensureImageAvailable($this$onApplicationStartedEvent_d1pmJ48_u24lambda_u245.justPdfToPpmImage);
                $this$onApplicationStartedEvent_d1pmJ48_u24lambda_u245.getAvailabilityTracker().setDocumentAvailable(true);
                object2 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = object2;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable == null) break block3;
            Object e = object2 = throwable;
            boolean bl = false;
            this.getAvailabilityTracker().setDocumentAvailable(false);
            this.logger.error("Failed to initialize document conversion", (Throwable)e);
        }
        return object;
    }

    public boolean isSupported(@NotNull MimeType mimeType) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
            Iterable $this$any$iv = this.allowedMimeTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    MimeType it = (MimeType)element$iv;
                    boolean bl2 = false;
                    if (!it.includes(mimeType)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<Path> convert(@NotNull Path inputFile, @NotNull MimeType mimeType, @NotNull Path tempDir) throws UnsupportedConversionException {
        Collection<Path> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable<Path> iterable;
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        Intrinsics.checkNotNullParameter((Object)mimeType, (String)"mimeType");
        Intrinsics.checkNotNullParameter((Object)tempDir, (String)"tempDir");
        Path it = iterable = Intrinsics.areEqual((Object)mimeType, (Object)MediaType.APPLICATION_PDF) ? this.scalePdf(inputFile, tempDir) : this.convertToPdf(inputFile, tempDir);
        boolean bl = false;
        this.logger.debug("Path to PDF: {}", (Object)it);
        Path pdfFile = iterable;
        Iterable<Path> files = iterable = this.getPdf2IFrameConversionService().convert(pdfFile, tempDir);
        boolean bl2 = false;
        Iterable iterable2 = files;
        Path path = tempDir;
        String string = "Files to publish from tempDir {}: {}";
        Logger logger = this.logger;
        boolean $i$f$map = false;
        void var13_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Path path2 = (Path)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            collection.add(tempDir.relativize((Path)it2));
        }
        collection = (List)destination$iv$iv;
        logger.debug(string, (Object)path, (Object)collection);
        return iterable;
    }

    private Path convertToPdf(Path inputFile, Path tempDir) {
        if (!Files.exists(inputFile, new LinkOption[0])) {
            boolean $i$a$-require-DocumentConversionService$convertToPdf$22 = false;
            String $i$a$-require-DocumentConversionService$convertToPdf$22 = "File " + inputFile + " does not exist";
            throw new IllegalArgumentException($i$a$-require-DocumentConversionService$convertToPdf$22.toString());
        }
        String containerInputDir = "/tmp/libreoffice-input";
        String containerOutputDir = "/tmp/libreoffice-output";
        Object[] objectArray = new String[]{"-v", inputFile.getParent().toAbsolutePath() + ":" + containerInputDir + ":ro,z", "-v", tempDir.toAbsolutePath() + ":" + containerOutputDir + ":z", this.libreOfficeImage, "libreoffice", "--headless", "--invisible", "--convert-to", "pdf:draw_pdf_Export:" + pdfExportConfiguration, "--outdir", containerOutputDir, containerInputDir + "/" + inputFile.getFileName()};
        CommandLineUtilsKt.podmanRun-BZiP2OM$default((List)CollectionsKt.listOf((Object[])objectArray), (PodmanConfig)this.getConfig().getPodman().getLibreoffice(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), (boolean)false, null, (int)24, null);
        Path tempPdfFile = tempDir.resolve(PathsKt.getNameWithoutExtension((Path)inputFile) + ".pdf");
        if (!Files.exists(tempPdfFile, new LinkOption[0])) {
            boolean bl = false;
            String string = "PDF conversion appeared to succeed but output file not found: " + tempPdfFile;
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNull((Object)tempPdfFile);
        return tempPdfFile;
    }

    private Path scalePdf(Path inputFile, Path tempDir) {
        List list;
        if (!Files.exists(inputFile, new LinkOption[0])) {
            boolean $i$a$-require-DocumentConversionService$scalePdf$22 = false;
            String $i$a$-require-DocumentConversionService$scalePdf$22 = "File " + inputFile + " does not exist";
            throw new IllegalArgumentException($i$a$-require-DocumentConversionService$scalePdf$22.toString());
        }
        Path inputDir = inputFile.getParent();
        String containerOutputDir = "/home/justsoftware/workspace";
        String containerOutputFileName = PathsKt.getNameWithoutExtension((Path)inputFile) + ".pdf";
        List $this$scalePdf_u24lambda_u2414 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        Object[] objectArray = new String[]{"--name", "pdf2cairo-" + PathsKt.getNameWithoutExtension((Path)inputFile), "-u", "justsoftware", "-v", inputDir + ":" + inputDir + ":Z", "-v", tempDir + ":" + containerOutputDir + ":Z", this.justPdfToPpmImage, "pdftocairo", "-pdf", "-paper", "A4", String.valueOf(inputFile), containerOutputDir + "/" + containerOutputFileName};
        $this$scalePdf_u24lambda_u2414.addAll(CollectionsKt.listOf((Object[])objectArray));
        CommandLineUtilsKt.podmanRun-BZiP2OM$default((List)CollectionsKt.build((List)list), (PodmanConfig)this.getConfig().getPodman().getPdftoppm(), (Duration)Duration.box-impl((long)DurationKt.toDuration((int)5, (DurationUnit)DurationUnit.MINUTES)), (boolean)false, null, (int)24, null);
        Path tempPdfFile = tempDir.resolve(containerOutputFileName);
        if (!Files.exists(tempPdfFile, new LinkOption[0])) {
            boolean bl2 = false;
            String string = "PDF conversion appeared to succeed but output file not found: " + tempPdfFile;
            throw new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNull((Object)tempPdfFile);
        return tempPdfFile;
    }

    public static final /* synthetic */ String access$getPdfExportConfiguration$cp() {
        return pdfExportConfiguration;
    }

    static {
        URL uRL = Companion.getClass().getClassLoader().getResource("assets/libreoffice-pdf-export-config.json");
        if (uRL == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        URL it = uRL;
        boolean bl = false;
        ObjectMapper objectMapper = new ObjectMapper();
        String string = objectMapper.writeValueAsString((Object)objectMapper.readTree(it));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"let(...)");
        pdfExportConfiguration = string;
    }
}

