/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.api;

import de.justsoftware.justdocumentz.api.VirusScanStatusMessage;
import de.justsoftware.justdocumentz.events.VirusScanStatusChangeEvent;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.event.EventListener;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.support.SendResult;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\u0002\u0010\u0005JV\u0010\b\u001aH\u0012D\u0012B\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001 \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\n0\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0017J^\u0010\u000e\u001aH\u0012D\u0012B\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001 \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00040\u0004\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00010\u0001\u0018\u00010\n0\n0\t2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0012R \u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lde/justsoftware/justdocumentz/api/VirusScanStatusPublisher;", "", "kafkaTemplate", "Lorg/springframework/kafka/core/KafkaTemplate;", "", "(Lorg/springframework/kafka/core/KafkaTemplate;)V", "getKafkaTemplate", "()Lorg/springframework/kafka/core/KafkaTemplate;", "onVirusScanStatusChange", "Ljava/util/concurrent/CompletableFuture;", "Lorg/springframework/kafka/support/SendResult;", "kotlin.jvm.PlatformType", "event", "Lde/justsoftware/justdocumentz/events/VirusScanStatusChangeEvent;", "publishStatus", "storageId", "message", "Lde/justsoftware/justdocumentz/api/VirusScanStatusMessage;", "just-documentz"})
public class VirusScanStatusPublisher {
    @NotNull
    private final KafkaTemplate<String, Object> kafkaTemplate;

    public VirusScanStatusPublisher(@NotNull KafkaTemplate<String, Object> kafkaTemplate) {
        Intrinsics.checkNotNullParameter(kafkaTemplate, (String)"kafkaTemplate");
        this.kafkaTemplate = kafkaTemplate;
    }

    @NotNull
    public KafkaTemplate<String, Object> getKafkaTemplate() {
        return this.kafkaTemplate;
    }

    private CompletableFuture<SendResult<String, Object>> publishStatus(String storageId, VirusScanStatusMessage message) {
        CompletableFuture completableFuture = this.getKafkaTemplate().send(new ProducerRecord("just.virus.scan.results", (Object)storageId, (Object)message));
        Intrinsics.checkNotNullExpressionValue((Object)completableFuture, (String)"send(...)");
        return completableFuture;
    }

    @EventListener(value={VirusScanStatusChangeEvent.class})
    @NotNull
    public CompletableFuture<SendResult<String, Object>> onVirusScanStatusChange(@NotNull VirusScanStatusChangeEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return this.publishStatus(event.getStorageId(), new VirusScanStatusMessage(event.getStatus(), event.getVirusSignatureCode(), event.getScanDate()));
    }
}

