/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.justdocumentz.api;

import de.justsoftware.justdocumentz.api.ConversionTask;
import de.justsoftware.justdocumentz.config.JudoConfig;
import de.justsoftware.justdocumentz.config.KafkaConfig;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.kafka.common.serialization.StringSerializer;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.kafka.config.ConcurrentKafkaListenerContainerFactory;
import org.springframework.kafka.core.ConsumerFactory;
import org.springframework.kafka.core.DefaultKafkaProducerFactory;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.kafka.core.ProducerFactory;
import org.springframework.kafka.listener.ContainerProperties;
import org.springframework.kafka.support.serializer.JsonSerializer;

@Configuration
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0014\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bH\u0017J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\fH\u0017J\u0014\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u000eH\u0017J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00010\u0010H\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lde/justsoftware/justdocumentz/api/ConversionTaskConsumerConfig;", "", "judoConfig", "Lde/justsoftware/justdocumentz/config/JudoConfig;", "kafkaConfig", "Lde/justsoftware/justdocumentz/config/KafkaConfig;", "(Lde/justsoftware/justdocumentz/config/JudoConfig;Lde/justsoftware/justdocumentz/config/KafkaConfig;)V", "conversionTaskConsumerFactory", "Lorg/springframework/kafka/core/ConsumerFactory;", "", "Lde/justsoftware/justdocumentz/api/ConversionTask;", "kafkaConversionTaskListenerContainerFactory", "Lorg/springframework/kafka/config/ConcurrentKafkaListenerContainerFactory;", "kafkaTemplate", "Lorg/springframework/kafka/core/KafkaTemplate;", "producerFactory", "Lorg/springframework/kafka/core/ProducerFactory;", "just-documentz"})
public class ConversionTaskConsumerConfig {
    @NotNull
    private final JudoConfig judoConfig;
    @NotNull
    private final KafkaConfig kafkaConfig;

    public ConversionTaskConsumerConfig(@NotNull JudoConfig judoConfig, @NotNull KafkaConfig kafkaConfig) {
        Intrinsics.checkNotNullParameter((Object)judoConfig, (String)"judoConfig");
        Intrinsics.checkNotNullParameter((Object)kafkaConfig, (String)"kafkaConfig");
        this.judoConfig = judoConfig;
        this.kafkaConfig = kafkaConfig;
    }

    @Bean
    @NotNull
    public ConsumerFactory<String, ConversionTask> conversionTaskConsumerFactory() {
        int maxPollInterval = (int)this.judoConfig.getConverter().getMaxVideoConversionDuration().plus(Duration.ofMinutes(5L)).toMillis();
        return this.kafkaConfig.createLongRunningConsumerFactory(ConversionTask.class, "conversion-task-group", MapsKt.mapOf((Pair)TuplesKt.to((Object)"max.poll.interval.ms", (Object)maxPollInterval)));
    }

    @Bean
    @NotNull
    public ConcurrentKafkaListenerContainerFactory<String, ConversionTask> kafkaConversionTaskListenerContainerFactory() {
        ConcurrentKafkaListenerContainerFactory factory = new ConcurrentKafkaListenerContainerFactory();
        factory.setConsumerFactory(this.conversionTaskConsumerFactory());
        factory.setConcurrency(Integer.valueOf(this.judoConfig.getConverter().getConcurrency()));
        factory.getContainerProperties().setAckMode(ContainerProperties.AckMode.RECORD);
        return factory;
    }

    @Bean
    @NotNull
    public ProducerFactory<String, Object> producerFactory() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"bootstrap.servers", (Object)this.kafkaConfig.getBootstrapServers()), TuplesKt.to((Object)"key.serializer", StringSerializer.class), TuplesKt.to((Object)"value.serializer", JsonSerializer.class)};
        Map props = MapsKt.mapOf((Pair[])pairArray);
        return (ProducerFactory)new DefaultKafkaProducerFactory(props);
    }

    @Bean
    @NotNull
    public KafkaTemplate<String, Object> kafkaTemplate() {
        return new KafkaTemplate(this.producerFactory());
    }
}

