/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.search;

import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lde/justsoftware/chat/search/SolrHealthIndicator;", "Lorg/springframework/boot/actuate/health/AbstractHealthIndicator;", "solrClients", "", "", "Lorg/apache/solr/client/solrj/SolrClient;", "<init>", "(Ljava/util/Map;)V", "doHealthCheck", "", "builder", "Lorg/springframework/boot/actuate/health/Health$Builder;", "chat-service"})
@SourceDebugExtension(value={"SMAP\nSolrHealthIndicator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SolrHealthIndicator.kt\nde/justsoftware/chat/search/SolrHealthIndicator\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,52:1\n216#2,2:53\n*S KotlinDebug\n*F\n+ 1 SolrHealthIndicator.kt\nde/justsoftware/chat/search/SolrHealthIndicator\n*L\n14#1:53,2\n*E\n"})
public class SolrHealthIndicator
extends AbstractHealthIndicator {
    @NotNull
    private final Map<String, SolrClient> solrClients;

    public SolrHealthIndicator(@NotNull Map<String, ? extends SolrClient> solrClients) {
        Intrinsics.checkNotNullParameter(solrClients, (String)"solrClients");
        super("Solr ping health check failed");
        this.solrClients = solrClients;
    }

    protected void doHealthCheck(@NotNull Health.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Map $this$forEach$iv = this.solrClients;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Pair[] pairArray;
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            Status status = Status.UP;
            SolrClient solrClient = (SolrClient)it.getValue();
            String baseUrl = solrClient instanceof Http2SolrClient ? ((Http2SolrClient)solrClient).getBaseURL() : "unknown";
            try {
                Status status2;
                SolrPingResponse response2 = ((SolrClient)it.getValue()).ping();
                if (response2.getStatus() == 0) {
                    status2 = Status.UP;
                } else {
                    status = Status.DOWN;
                    status2 = Status.DOWN;
                }
                Status solrSolrClientStatus = status2;
                pairArray = new Pair[]{TuplesKt.to((Object)"baseUrl", (Object)baseUrl), TuplesKt.to((Object)"status", (Object)solrSolrClientStatus.getCode()), TuplesKt.to((Object)"responseStatus", (Object)response2.getStatus())};
                builder.withDetail((String)it.getKey(), (Object)MapsKt.mapOf((Pair[])pairArray));
            }
            catch (Exception e) {
                pairArray = new Pair[]{TuplesKt.to((Object)"baseUrl", (Object)baseUrl), TuplesKt.to((Object)"status", (Object)Status.DOWN.getCode()), TuplesKt.to((Object)"error", (Object)e.getMessage())};
                builder.withDetail((String)it.getKey(), (Object)MapsKt.mapOf((Pair[])pairArray));
            }
            builder.status(status);
        }
    }
}

