/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.persistence;

import de.justsoftware.chat.business.ChatMessageService;
import de.justsoftware.chat.business.model.AttachmentFilter;
import de.justsoftware.chat.persistence.ChatMessageAttachmentSpecifications;
import de.justsoftware.chat.persistence.model.DbChatMessageAttachment;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.util.Collection;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.data.jpa.domain.Specification;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u00052\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00052\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\r\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005H\u0002J\u0016\u0010\u000e\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005H\u0002J\u0016\u0010\u000f\u001a\u0010\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005H\u0002J:\u0010\u0010\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00120\u0012 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00120\u0012\u0018\u00010\u00110\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002J:\u0010\u0015\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\t0\t \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\t0\t\u0018\u00010\u00110\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\u0014H\u0002\u00a8\u0006\u0016"}, d2={"Lde/justsoftware/chat/persistence/ChatMessageAttachmentSpecifications;", "", "<init>", "()V", "withChatId", "Lorg/springframework/data/jpa/domain/Specification;", "Lde/justsoftware/chat/persistence/model/DbChatMessageAttachment;", "kotlin.jvm.PlatformType", "chatId", "Ljava/util/UUID;", "withAttachmentType", "filter", "Lde/justsoftware/chat/business/model/AttachmentFilter;", "withImageAttachment", "withVideoAttachment", "withMediaAttachment", "attachmentMimeTypePath", "Ljakarta/persistence/criteria/Path;", "", "root", "Ljakarta/persistence/criteria/Root;", "chatIdPath", "chat-service"})
@SourceDebugExtension(value={"SMAP\nChatMessageAttachmentSpecifications.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChatMessageAttachmentSpecifications.kt\nde/justsoftware/chat/persistence/ChatMessageAttachmentSpecifications\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1#2:59\n1869#3,2:60\n*S KotlinDebug\n*F\n+ 1 ChatMessageAttachmentSpecifications.kt\nde/justsoftware/chat/persistence/ChatMessageAttachmentSpecifications\n*L\n47#1:60,2\n*E\n"})
public final class ChatMessageAttachmentSpecifications {
    @NotNull
    public static final ChatMessageAttachmentSpecifications INSTANCE = new ChatMessageAttachmentSpecifications();

    private ChatMessageAttachmentSpecifications() {
    }

    @NotNull
    public final Specification<DbChatMessageAttachment> withChatId(@NotNull UUID chatId) {
        Intrinsics.checkNotNullParameter((Object)chatId, (String)"chatId");
        return (arg_0, arg_1, arg_2) -> ChatMessageAttachmentSpecifications.withChatId$lambda$0(chatId, arg_0, arg_1, arg_2);
    }

    @Nullable
    public final Specification<DbChatMessageAttachment> withAttachmentType(@Nullable AttachmentFilter filter) {
        AttachmentFilter attachmentFilter = filter;
        return switch (attachmentFilter == null ? -1 : WhenMappings.$EnumSwitchMapping$0[attachmentFilter.ordinal()]) {
            case 1 -> this.withImageAttachment();
            case 2 -> this.withVideoAttachment();
            case 3 -> this.withMediaAttachment();
            case 4 -> Specification.not((Specification)this.withMediaAttachment());
            case 5 -> null;
            case -1 -> null;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final Specification<DbChatMessageAttachment> withImageAttachment() {
        return ChatMessageAttachmentSpecifications::withImageAttachment$lambda$0;
    }

    private final Specification<DbChatMessageAttachment> withVideoAttachment() {
        return ChatMessageAttachmentSpecifications::withVideoAttachment$lambda$0;
    }

    private final Specification<DbChatMessageAttachment> withMediaAttachment() {
        return ChatMessageAttachmentSpecifications::withMediaAttachment$lambda$0;
    }

    private final Path<String> attachmentMimeTypePath(Root<DbChatMessageAttachment> root) {
        return root.get("mimeType");
    }

    private final Path<UUID> chatIdPath(Root<DbChatMessageAttachment> root) {
        return root.join("chatMessage").get("chatId");
    }

    private static final Predicate withChatId$lambda$0(UUID $chatId, Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNull((Object)root);
        Path chatIdPath = INSTANCE.chatIdPath(root);
        Order[] orderArray = new Order[]{criteriaBuilder.desc((Expression)root.get("createdAt"))};
        criteriaQuery.orderBy(orderArray);
        return criteriaBuilder.equal((Expression)chatIdPath, (Object)$chatId);
    }

    private static final Predicate withImageAttachment$lambda$0(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNull((Object)root);
        return INSTANCE.attachmentMimeTypePath(root).in((Collection)ChatMessageService.Companion.getIMAGE_FORMATS());
    }

    private static final Predicate withVideoAttachment$lambda$0(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        Intrinsics.checkNotNull((Object)root);
        return criteriaBuilder.like((Expression)INSTANCE.attachmentMimeTypePath(root), "video/%");
    }

    /*
     * WARNING - void declaration
     */
    private static final Predicate withMediaAttachment$lambda$0(Root root, CriteriaQuery criteriaQuery, CriteriaBuilder criteriaBuilder) {
        void $this$forEach$iv;
        CriteriaBuilder.In in;
        Intrinsics.checkNotNull((Object)root);
        Path mimeTypePath = INSTANCE.attachmentMimeTypePath(root);
        CriteriaBuilder.In $this$withMediaAttachment_u24lambda_u240_u240 = in = criteriaBuilder.in((Expression)mimeTypePath);
        boolean bl = false;
        Iterable iterable = ChatMessageService.Companion.getIMAGE_FORMATS();
        Intrinsics.checkNotNull((Object)$this$withMediaAttachment_u24lambda_u240_u240);
        CriteriaBuilder.In in2 = $this$withMediaAttachment_u24lambda_u240_u240;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String p0 = (String)element$iv;
            boolean bl2 = false;
            in2.value((Object)p0);
        }
        CriteriaBuilder.In imagePredicate = in;
        Predicate videoPredicate = criteriaBuilder.like((Expression)mimeTypePath, "video/%");
        Predicate[] predicateArray = new Predicate[]{imagePredicate, videoPredicate};
        return criteriaBuilder.or(predicateArray);
    }
}

