/*
 * Decompiled with CFR 0.152.
 */
package de.justsoftware.chat.mobile.service;

import de.justsoftware.chat.business.model.event.ProfileDeletedEvent;
import de.justsoftware.chat.business.model.event.ProfileUpdatedEvent;
import de.justsoftware.chat.exception.ValidationException;
import de.justsoftware.chat.mobile.model.MobilePlatform;
import de.justsoftware.chat.mobile.model.MobilePushToken;
import de.justsoftware.chat.model.ProfileId;
import de.justsoftware.chat.model.ProfileStatus;
import de.justsoftware.chat.model.TenantId;
import de.justsoftware.chat.persistence.MobilePushTokenRepository;
import de.justsoftware.chat.persistence.model.DbMobilePushToken;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J(\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0016JB\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\bH\u0016J\u0016\u0010\u001c\u001a\u00020\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0016J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u0013\u001a\u00020\bH\u0017J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0017J\u0010\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&H\u0017JB\u0010'\u001a\u00020(2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0012J\u001e\u0010)\u001a\b\u0012\u0004\u0012\u00020(0*2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lde/justsoftware/chat/mobile/service/MobilePushTokenService;", "", "mobilePushTokenRepository", "Lde/justsoftware/chat/persistence/MobilePushTokenRepository;", "<init>", "(Lde/justsoftware/chat/persistence/MobilePushTokenRepository;)V", "findByProfileIds", "", "Lde/justsoftware/chat/model/ProfileId;", "", "Lde/justsoftware/chat/mobile/model/MobilePushToken;", "profileIds", "", "registerPushToken", "token", "", "mobilePlatform", "Lde/justsoftware/chat/mobile/model/MobilePlatform;", "publicKey", "profileId", "tenantId", "Lde/justsoftware/chat/model/TenantId;", "locale", "Ljava/util/Locale;", "iosSilenceAlerts", "", "unregisterPushToken", "", "deletePushTokens", "ids", "", "Lde/justsoftware/chat/mobile/model/MobilePushToken$Id;", "deleteByProfileId", "onProfileDeleted", "profileDeletedEvent", "Lde/justsoftware/chat/business/model/event/ProfileDeletedEvent;", "onProfileUpdated", "profileUpdatedEvent", "Lde/justsoftware/chat/business/model/event/ProfileUpdatedEvent;", "findOrCreate", "Lde/justsoftware/chat/persistence/model/DbMobilePushToken;", "findByTokenAndMobilePlatform", "Ljava/util/Optional;", "chat-service"})
@SourceDebugExtension(value={"SMAP\nMobilePushTokenService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MobilePushTokenService.kt\nde/justsoftware/chat/mobile/service/MobilePushTokenService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ValidationException.kt\nde/justsoftware/chat/exception/ValidationException$Companion\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,120:1\n1563#2:121\n1634#2,3:122\n1193#2,2:125\n1267#2,2:127\n1563#2:129\n1634#2,3:130\n1270#2:133\n1563#2:139\n1634#2,3:140\n6#3,2:134\n6#3,2:137\n1#4:136\n*S KotlinDebug\n*F\n+ 1 MobilePushTokenService.kt\nde/justsoftware/chat/mobile/service/MobilePushTokenService\n*L\n27#1:121\n27#1:122,3\n29#1:125,2\n29#1:127,2\n30#1:129\n30#1:130,3\n29#1:133\n61#1:139\n61#1:140,3\n42#1:134,2\n53#1:137,2\n*E\n"})
public class MobilePushTokenService {
    @NotNull
    private final MobilePushTokenRepository mobilePushTokenRepository;

    public MobilePushTokenService(@NotNull MobilePushTokenRepository mobilePushTokenRepository) {
        Intrinsics.checkNotNullParameter((Object)mobilePushTokenRepository, (String)"mobilePushTokenRepository");
        this.mobilePushTokenRepository = mobilePushTokenRepository;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public Map<ProfileId, List<MobilePushToken>> findByProfileIds(@NotNull Set<ProfileId> profileIds) {
        void $this$associateTo$iv$iv;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(profileIds, (String)"profileIds");
        Iterable iterable = profileIds;
        MobilePushTokenRepository mobilePushTokenRepository = this.mobilePushTokenRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ProfileId profileId = (ProfileId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.toCanonicalId());
        }
        Iterable $this$associate$iv = mobilePushTokenRepository.findByProfileIds((Iterable)((List)destination$iv$iv)).entrySet();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        destination$iv$iv = $this$associate$iv;
        Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map map = destination$iv$iv2;
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            String profileId = (String)entry.getKey();
            List dbPushTokens = (List)entry.getValue();
            Iterable iterable2 = dbPushTokens;
            ProfileId profileId2 = ProfileId.Companion.fromCanonicalId(profileId);
            boolean $i$f$map2 = false;
            void var18_24 = $this$map$iv2;
            Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                DbMobilePushToken dbMobilePushToken = (DbMobilePushToken)item$iv$iv;
                Collection collection = destination$iv$iv3;
                boolean bl2 = false;
                collection.add(DbMobilePushToken.Companion.toMobilePushToken((DbMobilePushToken)it));
            }
            entry = TuplesKt.to((Object)profileId2, (Object)((List)destination$iv$iv3));
            map.put(entry.getFirst(), entry.getSecond());
        }
        return destination$iv$iv2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public MobilePushToken registerPushToken(@NotNull String token, @NotNull MobilePlatform mobilePlatform, @Nullable String publicKey, @NotNull ProfileId profileId, @NotNull TenantId tenantId, @NotNull Locale locale, boolean iosSilenceAlerts) {
        void p0;
        void value$iv;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)mobilePlatform, (String)"mobilePlatform");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        Intrinsics.checkNotNullParameter((Object)tenantId, (String)"tenantId");
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        ValidationException.Companion companion = ValidationException.Companion;
        boolean bl = !StringsKt.isBlank((CharSequence)token);
        boolean $i$f$validate = false;
        if (value$iv == false) {
            boolean bl2 = false;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            String string = null;
            String string2 = "Token is blank".toString();
            throw new ValidationException(string2, string, n, defaultConstructorMarker);
        }
        DbMobilePushToken dbMobilePushToken = this.findOrCreate(token, mobilePlatform, publicKey, profileId, tenantId, locale, iosSilenceAlerts);
        MobilePushTokenRepository mobilePushTokenRepository = this.mobilePushTokenRepository;
        DbMobilePushToken bl2 = dbMobilePushToken;
        DbMobilePushToken.Companion companion2 = DbMobilePushToken.Companion;
        boolean bl3 = false;
        DbMobilePushToken dbMobilePushToken2 = (DbMobilePushToken)mobilePushTokenRepository.save((Object)p0);
        Intrinsics.checkNotNullExpressionValue((Object)dbMobilePushToken2, (String)"let(...)");
        return companion2.toMobilePushToken(dbMobilePushToken2);
    }

    /*
     * WARNING - void declaration
     */
    public void unregisterPushToken(@NotNull String token, @NotNull MobilePlatform mobilePlatform, @NotNull ProfileId profileId) {
        void value$iv;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)mobilePlatform, (String)"mobilePlatform");
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        ValidationException.Companion companion = ValidationException.Companion;
        boolean bl = !StringsKt.isBlank((CharSequence)token);
        boolean $i$f$validate = false;
        if (value$iv == false) {
            boolean bl2 = false;
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 2;
            String string = null;
            String string2 = "Token is blank".toString();
            throw new ValidationException(string2, string, n, defaultConstructorMarker);
        }
        this.findByTokenAndMobilePlatform(token, mobilePlatform).filter(arg_0 -> MobilePushTokenService.unregisterPushToken$lambda$2(arg_0 -> MobilePushTokenService.unregisterPushToken$lambda$1(profileId, arg_0), arg_0)).ifPresent(arg_0 -> MobilePushTokenService.unregisterPushToken$lambda$3((Function1)new /* Unavailable Anonymous Inner Class!! */, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    public void deletePushTokens(@NotNull Iterable<MobilePushToken.Id> ids) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Iterable<MobilePushToken.Id> iterable = ids;
        MobilePushTokenRepository mobilePushTokenRepository = this.mobilePushTokenRepository;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MobilePushToken.Id id = (MobilePushToken.Id)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DbMobilePushToken.Companion.toDbMobilePushTokenId((MobilePushToken.Id)it));
        }
        mobilePushTokenRepository.deleteAllByIdInBatch((Iterable)((List)destination$iv$iv));
    }

    @Transactional
    public void deleteByProfileId(@NotNull ProfileId profileId) {
        Intrinsics.checkNotNullParameter((Object)profileId, (String)"profileId");
        this.mobilePushTokenRepository.deleteByProfileId(profileId.toCanonicalId());
    }

    @EventListener
    @Transactional
    public void onProfileDeleted(@NotNull ProfileDeletedEvent profileDeletedEvent) {
        Intrinsics.checkNotNullParameter((Object)profileDeletedEvent, (String)"profileDeletedEvent");
        this.deleteByProfileId(profileDeletedEvent.getProfileId());
    }

    @EventListener
    @Transactional
    public void onProfileUpdated(@NotNull ProfileUpdatedEvent profileUpdatedEvent) {
        Intrinsics.checkNotNullParameter((Object)profileUpdatedEvent, (String)"profileUpdatedEvent");
        if (profileUpdatedEvent.getOldStatus() == ProfileStatus.ACTIVE && profileUpdatedEvent.getNewStatus() != ProfileStatus.ACTIVE) {
            this.deleteByProfileId(profileUpdatedEvent.getProfileId());
        }
    }

    private DbMobilePushToken findOrCreate(String token, MobilePlatform mobilePlatform, String publicKey, ProfileId profileId, TenantId tenantId, Locale locale, boolean iosSilenceAlerts) {
        DbMobilePushToken dbMobilePushToken = this.findByTokenAndMobilePlatform(token, mobilePlatform).map(arg_0 -> MobilePushTokenService.findOrCreate$lambda$1(arg_0 -> MobilePushTokenService.findOrCreate$lambda$0(publicKey, profileId, tenantId, locale, iosSilenceAlerts, arg_0), arg_0)).orElseGet(() -> MobilePushTokenService.findOrCreate$lambda$2(token, mobilePlatform, publicKey, profileId, tenantId, locale, iosSilenceAlerts));
        Intrinsics.checkNotNullExpressionValue((Object)dbMobilePushToken, (String)"orElseGet(...)");
        return dbMobilePushToken;
    }

    private Optional<DbMobilePushToken> findByTokenAndMobilePlatform(String token, MobilePlatform mobilePlatform) {
        Optional optional = this.mobilePushTokenRepository.findById((Object)new DbMobilePushToken.Id(token, mobilePlatform));
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"findById(...)");
        return optional;
    }

    private static final boolean unregisterPushToken$lambda$1(ProfileId $profileId, DbMobilePushToken it) {
        return Intrinsics.areEqual((Object)it.getProfileId(), (Object)$profileId.toCanonicalId());
    }

    private static final boolean unregisterPushToken$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void unregisterPushToken$lambda$3(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final DbMobilePushToken findOrCreate$lambda$0(String $publicKey, ProfileId $profileId, TenantId $tenantId, Locale $locale, boolean $iosSilenceAlerts, DbMobilePushToken it) {
        DbMobilePushToken dbMobilePushToken;
        DbMobilePushToken $this$findOrCreate_u24lambda_u240_u240 = dbMobilePushToken = it;
        boolean bl = false;
        String string = $publicKey;
        if (string == null) {
            string = $this$findOrCreate_u24lambda_u240_u240.getPublicKey();
        }
        $this$findOrCreate_u24lambda_u240_u240.setPublicKey(string);
        $this$findOrCreate_u24lambda_u240_u240.setProfileId($profileId.toCanonicalId());
        $this$findOrCreate_u24lambda_u240_u240.setTenantId($tenantId.getValue());
        $this$findOrCreate_u24lambda_u240_u240.setLocale($locale);
        $this$findOrCreate_u24lambda_u240_u240.setIosSilenceAlerts($iosSilenceAlerts);
        return dbMobilePushToken;
    }

    private static final DbMobilePushToken findOrCreate$lambda$1(Function1 $tmp0, Object p0) {
        return (DbMobilePushToken)$tmp0.invoke(p0);
    }

    private static final DbMobilePushToken findOrCreate$lambda$2(String $token, MobilePlatform $mobilePlatform, String $publicKey, ProfileId $profileId, TenantId $tenantId, Locale $locale, boolean $iosSilenceAlerts) {
        return new DbMobilePushToken($token, $mobilePlatform, $publicKey, $profileId.toCanonicalId(), $tenantId.getValue(), $locale, $iosSilenceAlerts);
    }
}

